/*
 * Decompiled with CFR 0.152.
 */
package org.gciatto.kt.math;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.ranges.ClosedRange;
import org.gciatto.kt.math.BigInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010(\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\t\u0010\n\u001a\u00020\u0002H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0002H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0002H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0014H\u0096\u0002J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0014\u0010\u0005\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0017"}, d2={"Lorg/gciatto/kt/math/BigIntegerRange;", "Lkotlin/ranges/ClosedRange;", "Lorg/gciatto/kt/math/BigInteger;", "", "start", "endInclusive", "(Lorg/gciatto/kt/math/BigInteger;Lorg/gciatto/kt/math/BigInteger;)V", "getEndInclusive", "()Lorg/gciatto/kt/math/BigInteger;", "getStart", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "iterator", "", "toString", "", "kt-math"})
public final class BigIntegerRange
implements ClosedRange<BigInteger>,
Iterable<BigInteger>,
KMappedMarker {
    @NotNull
    private final BigInteger start;
    @NotNull
    private final BigInteger endInclusive;

    public BigIntegerRange(@NotNull BigInteger start, @NotNull BigInteger endInclusive) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)endInclusive, (String)"endInclusive");
        this.start = start;
        this.endInclusive = endInclusive;
    }

    @NotNull
    public BigInteger getStart() {
        return this.start;
    }

    @NotNull
    public BigInteger getEndInclusive() {
        return this.endInclusive;
    }

    @Override
    @NotNull
    public Iterator<BigInteger> iterator() {
        return new Iterator<BigInteger>(this){
            @NotNull
            private BigInteger current;
            final /* synthetic */ BigIntegerRange this$0;
            {
                this.this$0 = $receiver;
                this.current = $receiver.getStart();
            }

            public boolean hasNext() {
                return this.current.compareTo(this.this$0.getEndInclusive()) <= 0;
            }

            @NotNull
            public BigInteger next() {
                BigInteger temp = this.current;
                this.current = this.current.plus(BigInteger.ONE);
                return temp;
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    public boolean contains(@NotNull BigInteger value) {
        return ClosedRange.DefaultImpls.contains((ClosedRange)this, (Comparable)value);
    }

    public boolean isEmpty() {
        return ClosedRange.DefaultImpls.isEmpty((ClosedRange)this);
    }

    @NotNull
    public final BigInteger component1() {
        return this.start;
    }

    @NotNull
    public final BigInteger component2() {
        return this.endInclusive;
    }

    @NotNull
    public final BigIntegerRange copy(@NotNull BigInteger start, @NotNull BigInteger endInclusive) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)endInclusive, (String)"endInclusive");
        return new BigIntegerRange(start, endInclusive);
    }

    public static /* synthetic */ BigIntegerRange copy$default(BigIntegerRange bigIntegerRange, BigInteger bigInteger, BigInteger bigInteger2, int n, Object object) {
        if ((n & 1) != 0) {
            bigInteger = bigIntegerRange.start;
        }
        if ((n & 2) != 0) {
            bigInteger2 = bigIntegerRange.endInclusive;
        }
        return bigIntegerRange.copy(bigInteger, bigInteger2);
    }

    @NotNull
    public String toString() {
        return "BigIntegerRange(start=" + this.start + ", endInclusive=" + this.endInclusive + ')';
    }

    public int hashCode() {
        int result = ((Object)this.start).hashCode();
        result = result * 31 + ((Object)this.endInclusive).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BigIntegerRange)) {
            return false;
        }
        BigIntegerRange bigIntegerRange = (BigIntegerRange)other;
        if (!Intrinsics.areEqual((Object)this.start, (Object)bigIntegerRange.start)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.endInclusive, (Object)bigIntegerRange.endInclusive);
    }
}

