/*
 * Decompiled with CFR 0.152.
 */
package io.github.gciatto.kt.mpp;

import io.github.gciatto.kt.mpp.ProjectUtilsKt;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.logging.LogLevel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0014\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00c6\u0003J3\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0001H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00062\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\u0010\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0015\u0010\u001f\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b!J\t\u0010\"\u001a\u00020\u0003H\u00d6\u0001R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\r\u00a8\u0006#"}, d2={"Lio/github/gciatto/kt/mpp/PropertyDescriptor;", "", "name", "", "description", "mandatory", "", "defaultValue", "(Ljava/lang/String;Ljava/lang/String;ZLjava/lang/Object;)V", "alreadyLogged", "getDefaultValue", "()Ljava/lang/Object;", "getDescription", "()Ljava/lang/String;", "explanation", "getExplanation$kt_mpp", "getMandatory", "()Z", "getName", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "helpMessage", "project", "Lorg/gradle/api/Project;", "logHelpIfNecessary", "", "logHelpIfNecessary$kt_mpp", "toString", "kt-mpp"})
@SourceDebugExtension(value={"SMAP\nPropertyDescriptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PropertyDescriptor.kt\nio/github/gciatto/kt/mpp/PropertyDescriptor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,63:1\n1#2:64\n*E\n"})
public final class PropertyDescriptor {
    @NotNull
    private final String name;
    @NotNull
    private final String description;
    private final boolean mandatory;
    @Nullable
    private final Object defaultValue;
    private boolean alreadyLogged;

    public PropertyDescriptor(@NotNull String name, @NotNull String description, boolean mandatory, @Nullable Object defaultValue) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        this.name = name;
        this.description = description;
        this.mandatory = mandatory;
        this.defaultValue = defaultValue;
    }

    public /* synthetic */ PropertyDescriptor(String string, String string2, boolean bl, Object object, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            object = null;
        }
        this(string, string2, bl, object);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    public final boolean getMandatory() {
        return this.mandatory;
    }

    @Nullable
    public final Object getDefaultValue() {
        return this.defaultValue;
    }

    private final String helpMessage(Project project) {
        StringBuilder result = new StringBuilder();
        Project rootProject = project.getRootProject();
        Object object = this.defaultValue;
        if (object == null) {
            object = "<value>";
        }
        Object value = object;
        result.append(this.mandatory ? "mandatory" : "optional").append(" property " + this.name + " is missing.\n").append(this.getExplanation$kt_mpp()).append("\n").append("Things you can do to avoid this ").append(this.mandatory ? "error" : "warning").append(":\n").append("1. invoke Gradle with -P" + this.name + "=" + value + " option;\n").append("2. invoke Gradle after setting ORG_GRADLE_PROJECT_" + this.name + "=" + value + " environment variable;\n");
        if (!Intrinsics.areEqual((Object)project, (Object)rootProject)) {
            StringBuilder stringBuilder = result.append("3. add a line containing " + this.name + "=" + value + " in the file " + ProjectUtilsKt.getGradlePropertiesPath(project) + ";\n");
            Intrinsics.checkNotNullExpressionValue((Object)rootProject, (String)"rootProject");
            stringBuilder.append("4. add a line containing " + this.name + "=" + value + " in the file " + ProjectUtilsKt.getGradlePropertiesPath(rootProject) + ".\n").append("We recommend to do step 3 or 4 in any case, using a (possibly blank) default value, ");
        } else {
            result.append("3. add a line containing " + this.name + "=" + value + " in the file " + ProjectUtilsKt.getGradlePropertiesPath(project) + ";\n").append("We recommend (i) doing step 3 in any case, using a (possibly blank) default value, ");
        }
        result.append("or (ii) running task ").append(project.getTasks().getByName("generateGradlePropertiesFile").getPath()).append(" to generate the gradle.properties file automatically.");
        CharSequence charSequence = result;
        Regex regex = new Regex("\\n");
        String string = "\n    ";
        return regex.replace(charSequence, string);
    }

    public final void logHelpIfNecessary$kt_mpp(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!this.alreadyLogged) {
            ProjectUtilsKt.log(project, this.helpMessage(project), this.mandatory ? LogLevel.ERROR : LogLevel.WARN);
            this.alreadyLogged = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getExplanation$kt_mpp() {
        String string;
        StringBuilder sb = new StringBuilder("Property " + this.name + " (");
        sb.append(this.mandatory ? "mandatory" : "optional");
        if (this.defaultValue != null) {
            sb.append(", default value: ");
            if (this.defaultValue instanceof String) {
                sb.append("'" + StringsKt.replace$default((String)((String)this.defaultValue), (String)"'", (String)"'", (boolean)false, (int)4, null) + "'");
            } else {
                sb.append(this.defaultValue);
            }
        }
        sb.append("): ");
        StringBuilder stringBuilder = sb;
        String string2 = this.description;
        if (((CharSequence)string2).length() > 0) {
            void it;
            char c = string2.charAt(0);
            StringBuilder stringBuilder2 = new StringBuilder();
            StringBuilder stringBuilder3 = stringBuilder;
            boolean bl = false;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
            String string3 = CharsKt.lowercase((char)it, (Locale)locale);
            stringBuilder = stringBuilder3;
            StringBuilder stringBuilder4 = stringBuilder2.append((Object)string3);
            String string4 = string2;
            int n = 1;
            String string5 = string4.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).substring(startIndex)");
            string = stringBuilder4.append(string5).toString();
        } else {
            string = string2;
        }
        stringBuilder.append(string);
        String string6 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"sb.toString()");
        return string6;
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final String component2() {
        return this.description;
    }

    public final boolean component3() {
        return this.mandatory;
    }

    @Nullable
    public final Object component4() {
        return this.defaultValue;
    }

    @NotNull
    public final PropertyDescriptor copy(@NotNull String name, @NotNull String description, boolean mandatory, @Nullable Object defaultValue) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        return new PropertyDescriptor(name, description, mandatory, defaultValue);
    }

    public static /* synthetic */ PropertyDescriptor copy$default(PropertyDescriptor propertyDescriptor, String string, String string2, boolean bl, Object object, int n, Object object2) {
        if ((n & 1) != 0) {
            string = propertyDescriptor.name;
        }
        if ((n & 2) != 0) {
            string2 = propertyDescriptor.description;
        }
        if ((n & 4) != 0) {
            bl = propertyDescriptor.mandatory;
        }
        if ((n & 8) != 0) {
            object = propertyDescriptor.defaultValue;
        }
        return propertyDescriptor.copy(string, string2, bl, object);
    }

    @NotNull
    public String toString() {
        return "PropertyDescriptor(name=" + this.name + ", description=" + this.description + ", mandatory=" + this.mandatory + ", defaultValue=" + this.defaultValue + ")";
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + this.description.hashCode();
        int n = this.mandatory ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result = result * 31 + n;
        result = result * 31 + (this.defaultValue == null ? 0 : this.defaultValue.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PropertyDescriptor)) {
            return false;
        }
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)propertyDescriptor.name)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.description, (Object)propertyDescriptor.description)) {
            return false;
        }
        if (this.mandatory != propertyDescriptor.mandatory) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.defaultValue, (Object)propertyDescriptor.defaultValue);
    }
}

