/*
 * Decompiled with CFR 0.152.
 */
package io.github.gciatto.kt.mpp;

import io.github.gciatto.kt.mpp.AbstractProjectPlugin;
import io.github.gciatto.kt.mpp.Developer;
import io.github.gciatto.kt.mpp.ProjectUtilsKt;
import io.github.gciatto.kt.mpp.PropertiesHelperExtension;
import io.github.gciatto.kt.mpp.PublishOnMavenPlugin;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.artifacts.repositories.PasswordCredentials;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.plugins.PluginAware;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.MavenPom;
import org.gradle.api.publish.maven.MavenPomDeveloperSpec;
import org.gradle.api.publish.maven.MavenPomLicense;
import org.gradle.api.publish.maven.MavenPomLicenseSpec;
import org.gradle.api.publish.maven.MavenPomScm;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.kotlin.dsl.PluginAwareExtensionsKt;
import org.gradle.plugins.signing.Sign;
import org.gradle.plugins.signing.SigningExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u000b\u001a\u00020\f*\u00020\rH\u0002J\f\u0010\u000e\u001a\u00020\f*\u00020\rH\u0014J\f\u0010\u000f\u001a\u00020\f*\u00020\rH\u0002J\f\u0010\u0010\u001a\u00020\f*\u00020\rH\u0002J\f\u0010\u0011\u001a\u00020\f*\u00020\u0012H\u0014J\f\u0010\u0013\u001a\u00020\f*\u00020\rH\u0002R&\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0086.\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lio/github/gciatto/kt/mpp/PublishOnMavenPlugin;", "Lio/github/gciatto/kt/mpp/AbstractProjectPlugin;", "()V", "publishableClassifiers", "Lorg/gradle/api/DomainObjectSet;", "", "getPublishableClassifiers$annotations", "getPublishableClassifiers", "()Lorg/gradle/api/DomainObjectSet;", "setPublishableClassifiers", "(Lorg/gradle/api/DomainObjectSet;)V", "addMissingPublications", "", "Lorg/gradle/api/Project;", "applyThisPlugin", "configureMavenRepository", "configureSigning", "declareProperties", "Lio/github/gciatto/kt/mpp/PropertiesHelperExtension;", "lazilyConfigurePOM", "kt-mpp"})
public final class PublishOnMavenPlugin
extends AbstractProjectPlugin {
    public DomainObjectSet<String> publishableClassifiers;

    @NotNull
    public final DomainObjectSet<String> getPublishableClassifiers() {
        DomainObjectSet<String> domainObjectSet = this.publishableClassifiers;
        if (domainObjectSet != null) {
            return domainObjectSet;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"publishableClassifiers");
        return null;
    }

    public final void setPublishableClassifiers(@NotNull DomainObjectSet<String> domainObjectSet) {
        Intrinsics.checkNotNullParameter(domainObjectSet, (String)"<set-?>");
        this.publishableClassifiers = domainObjectSet;
    }

    public static /* synthetic */ void getPublishableClassifiers$annotations() {
    }

    @Override
    protected void declareProperties(@NotNull PropertiesHelperExtension $this$declareProperties) {
        Intrinsics.checkNotNullParameter((Object)$this$declareProperties, (String)"<this>");
        $this$declareProperties.addProperty$kt_mpp($this$declareProperties.getMavenRepo());
        $this$declareProperties.addProperty$kt_mpp($this$declareProperties.getMavenUsername());
        $this$declareProperties.addProperty$kt_mpp($this$declareProperties.getMavenPassword());
        $this$declareProperties.addProperty$kt_mpp($this$declareProperties.getSigningKey());
        $this$declareProperties.addProperty$kt_mpp($this$declareProperties.getSigningPassword());
        $this$declareProperties.addProperty$kt_mpp($this$declareProperties.getProjectLongName());
        $this$declareProperties.addProperty$kt_mpp($this$declareProperties.getProjectDescription());
        $this$declareProperties.addProperty$kt_mpp($this$declareProperties.getProjectHomepage());
        $this$declareProperties.addProperty$kt_mpp($this$declareProperties.getProjectLicense());
        $this$declareProperties.addProperty$kt_mpp($this$declareProperties.getProjectLicenseUrl());
        $this$declareProperties.addProperty$kt_mpp($this$declareProperties.getScmConnection());
        $this$declareProperties.addProperty$kt_mpp($this$declareProperties.getScmUrl());
        $this$declareProperties.addProperty$kt_mpp($this$declareProperties.getDeveloperIdName());
        $this$declareProperties.addProperty$kt_mpp($this$declareProperties.getDeveloperIdUrl());
        $this$declareProperties.addProperty$kt_mpp($this$declareProperties.getDeveloperIdEmail());
        $this$declareProperties.addProperty$kt_mpp($this$declareProperties.getDeveloperIdOrg());
        $this$declareProperties.addProperty$kt_mpp($this$declareProperties.getOrgName());
        $this$declareProperties.addProperty$kt_mpp($this$declareProperties.getOrgUrl());
    }

    private final void configureMavenRepository(Project $this$configureMavenRepository) {
        this.configure($this$configureMavenRepository, Reflection.getOrCreateKotlinClass(PublishingExtension.class), (Function1)new Function1<PublishingExtension, Unit>(this, $this$configureMavenRepository){
            final /* synthetic */ PublishOnMavenPlugin this$0;
            final /* synthetic */ Project $this_configureMavenRepository;
            {
                this.this$0 = $receiver;
                this.$this_configureMavenRepository = $receiver2;
                super(1);
            }

            public final void invoke(@NotNull PublishingExtension $this$configure) {
                Intrinsics.checkNotNullParameter((Object)$this$configure, (String)"$this$configure");
                $this$configure.repositories(arg_0 -> configureMavenRepository.1.invoke$lambda$0((Function1)new Function1<RepositoryHandler, Unit>(this.this$0, this.$this_configureMavenRepository){
                    final /* synthetic */ PublishOnMavenPlugin this$0;
                    final /* synthetic */ Project $this_configureMavenRepository;
                    {
                        this.this$0 = $receiver;
                        this.$this_configureMavenRepository = $receiver2;
                        super(1);
                    }

                    public final void invoke(RepositoryHandler repos) {
                        repos.maven(arg_0 -> configureMavenRepository.1.invoke$lambda$0((Function1)new Function1<MavenArtifactRepository, Unit>(this.this$0, this.$this_configureMavenRepository){
                            final /* synthetic */ PublishOnMavenPlugin this$0;
                            final /* synthetic */ Project $this_configureMavenRepository;
                            {
                                this.this$0 = $receiver;
                                this.$this_configureMavenRepository = $receiver2;
                                super(1);
                            }

                            public final void invoke(MavenArtifactRepository maven) {
                                String string = this.this$0.getOptionalProperty(this.$this_configureMavenRepository, "mavenRepo");
                                if (string != null) {
                                    String string2 = string;
                                    Project project = this.$this_configureMavenRepository;
                                    String it = string2;
                                    boolean bl = false;
                                    maven.setUrl(project.uri((Object)it));
                                }
                                String mavenUsername = this.this$0.getOptionalProperty(this.$this_configureMavenRepository, "mavenUsername");
                                String mavenPassword = this.this$0.getOptionalProperty(this.$this_configureMavenRepository, "mavenPassword");
                                if (mavenUsername != null && mavenPassword != null) {
                                    maven.credentials(arg_0 -> configureMavenRepository.1.invoke$lambda$1((Function1)new Function1<PasswordCredentials, Unit>(mavenUsername, mavenPassword){
                                        final /* synthetic */ String $mavenUsername;
                                        final /* synthetic */ String $mavenPassword;
                                        {
                                            this.$mavenUsername = $mavenUsername;
                                            this.$mavenPassword = $mavenPassword;
                                            super(1);
                                        }

                                        public final void invoke(PasswordCredentials it) {
                                            it.setUsername(this.$mavenUsername);
                                            it.setPassword(this.$mavenPassword);
                                        }
                                    }, arg_0));
                                    ProjectUtilsKt.log$default(this.$this_configureMavenRepository, "configure Maven repository " + maven.getName() + " (URL: " + maven.getUrl() + ", username: " + this.this$0.asField(maven.getCredentials().getUsername()) + ", password: " + this.this$0.asPassword(maven.getCredentials().getPassword()) + ")", null, 2, null);
                                } else {
                                    ProjectUtilsKt.log(this.$this_configureMavenRepository, "configure Maven repository " + maven.getName() + " with no credentials", LogLevel.WARN);
                                }
                            }

                            private static final void invoke$lambda$1(Function1 $tmp0, Object p0) {
                                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                                $tmp0.invoke(p0);
                            }
                        }, arg_0));
                    }

                    private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                        $tmp0.invoke(p0);
                    }
                }, arg_0));
            }

            private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }
        });
    }

    private final void configureSigning(Project $this$configureSigning) {
        this.configure($this$configureSigning, Reflection.getOrCreateKotlinClass(PublishingExtension.class), (Function1)new Function1<PublishingExtension, Unit>(this, $this$configureSigning){
            final /* synthetic */ PublishOnMavenPlugin this$0;
            final /* synthetic */ Project $this_configureSigning;
            {
                this.this$0 = $receiver;
                this.$this_configureSigning = $receiver2;
                super(1);
            }

            public final void invoke(@NotNull PublishingExtension $this$configure) {
                Intrinsics.checkNotNullParameter((Object)$this$configure, (String)"$this$configure");
                this.this$0.configure(this.$this_configureSigning, Reflection.getOrCreateKotlinClass(SigningExtension.class), (Function1)new Function1<SigningExtension, Unit>(this.this$0, this.$this_configureSigning, $this$configure){
                    final /* synthetic */ PublishOnMavenPlugin this$0;
                    final /* synthetic */ Project $this_configureSigning;
                    final /* synthetic */ PublishingExtension $this_configure;
                    {
                        this.this$0 = $receiver;
                        this.$this_configureSigning = $receiver2;
                        this.$this_configure = $this_configure;
                        super(1);
                    }

                    public final void invoke(@NotNull SigningExtension $this$configure) {
                        boolean bl;
                        String signingPassword;
                        String signingKey;
                        block3: {
                            Intrinsics.checkNotNullParameter((Object)$this$configure, (String)"$this$configure");
                            signingKey = this.this$0.getOptionalProperty(this.$this_configureSigning, "signingKey");
                            signingPassword = this.this$0.getOptionalProperty(this.$this_configureSigning, "signingPassword");
                            String[] stringArray = new String[]{signingKey, signingPassword};
                            String[] $this$none$iv = stringArray;
                            boolean $i$f$none = false;
                            int n = $this$none$iv.length;
                            for (int j = 0; j < n; ++j) {
                                String element$iv;
                                String it = element$iv = $this$none$iv[j];
                                boolean bl2 = false;
                                CharSequence charSequence = it;
                                boolean bl3 = charSequence == null || StringsKt.isBlank((CharSequence)charSequence);
                                if (!bl3) continue;
                                bl = false;
                                break block3;
                            }
                            bl = true;
                        }
                        if (bl) {
                            $this$configure.useInMemoryPgpKeys(signingKey, signingPassword);
                            $this$configure.sign((DomainObjectCollection)this.$this_configure.getPublications());
                            SortedSet sortedSet = this.$this_configure.getPublications().getNames();
                            Intrinsics.checkNotNullExpressionValue((Object)sortedSet, (String)"publications.names");
                            ProjectUtilsKt.log$default(this.$this_configureSigning, "configure signing for publications: " + CollectionsKt.joinToString$default((Iterable)sortedSet, null, null, null, (int)0, null, null, (int)63, null), null, 2, null);
                        } else {
                            ProjectUtilsKt.log$default(this.$this_configureSigning, "one property in {signingKey, signingPassword} is unset or blank, hence Maven publications won't be signed", null, 2, null);
                        }
                        Task signAll = $this$configure.getProject().getTasks().create("signAllPublications");
                        $this$configure.getProject().getTasks().withType(Sign.class, arg_0 -> configureSigning.1.invoke$lambda$1((Function1)new Function1<Sign, Unit>(signAll, this.$this_configureSigning){
                            final /* synthetic */ Task $signAll;
                            final /* synthetic */ Project $this_configureSigning;
                            {
                                this.$signAll = $signAll;
                                this.$this_configureSigning = $receiver;
                                super(1);
                            }

                            public final void invoke(Sign it) {
                                Object[] objectArray = new Object[]{it};
                                this.$signAll.dependsOn(objectArray);
                                ProjectUtilsKt.log$default(this.$this_configureSigning, "create signAllPublications tasks depending on " + it.getPath(), null, 2, null);
                            }
                        }, arg_0));
                    }

                    private static final void invoke$lambda$1(Function1 $tmp0, Object p0) {
                        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                        $tmp0.invoke(p0);
                    }
                });
            }
        });
    }

    private final void addMissingPublications(Project $this$addMissingPublications) {
        this.configure($this$addMissingPublications, Reflection.getOrCreateKotlinClass(PublishingExtension.class), (Function1)new Function1<PublishingExtension, Unit>(this, $this$addMissingPublications){
            final /* synthetic */ PublishOnMavenPlugin this$0;
            final /* synthetic */ Project $this_addMissingPublications;
            {
                this.this$0 = $receiver;
                this.$this_addMissingPublications = $receiver2;
                super(1);
            }

            public final void invoke(@NotNull PublishingExtension $this$configure) {
                Intrinsics.checkNotNullParameter((Object)$this$configure, (String)"$this$configure");
                this.this$0.configure(this.$this_addMissingPublications, Reflection.getOrCreateKotlinClass(SigningExtension.class), (Function1)new Function1<SigningExtension, Unit>(this.$this_addMissingPublications, $this$configure){
                    final /* synthetic */ Project $this_addMissingPublications;
                    final /* synthetic */ PublishingExtension $this_configure;
                    {
                        this.$this_addMissingPublications = $receiver;
                        this.$this_configure = $this_configure;
                        super(1);
                    }

                    public final void invoke(@NotNull SigningExtension $this$configure) {
                        Intrinsics.checkNotNullParameter((Object)$this$configure, (String)"$this$configure");
                        this.$this_addMissingPublications.getPlugins().withId("org.jetbrains.kotlin.jvm", arg_0 -> addMissingPublications.1.invoke$lambda$0((Function1)new Function1<Plugin<?>, Unit>(this.$this_configure, this.$this_addMissingPublications){
                            final /* synthetic */ PublishingExtension $this_configure;
                            final /* synthetic */ Project $this_addMissingPublications;
                            {
                                this.$this_configure = $this_configure;
                                this.$this_addMissingPublications = $receiver;
                                super(1);
                            }

                            public final void invoke(Plugin<?> it) {
                                Object object = this.$this_configure.getPublications().maybeCreate("jvm", MavenPublication.class);
                                Project project = this.$this_addMissingPublications;
                                MavenPublication $this$invoke_u24lambda_u240 = (MavenPublication)object;
                                boolean bl = false;
                                $this$invoke_u24lambda_u240.from((SoftwareComponent)project.getComponents().getAt("java"));
                                ProjectUtilsKt.log$default(project, "add jvm publication from java component", null, 2, null);
                            }
                        }, arg_0));
                        this.$this_addMissingPublications.getPlugins().withId("org.jetbrains.kotlin.js", arg_0 -> addMissingPublications.1.invoke$lambda$1((Function1)new Function1<Plugin<?>, Unit>(this.$this_configure, this.$this_addMissingPublications){
                            final /* synthetic */ PublishingExtension $this_configure;
                            final /* synthetic */ Project $this_addMissingPublications;
                            {
                                this.$this_configure = $this_configure;
                                this.$this_addMissingPublications = $receiver;
                                super(1);
                            }

                            public final void invoke(Plugin<?> it) {
                                Object object = this.$this_configure.getPublications().maybeCreate("js", MavenPublication.class);
                                Project project = this.$this_addMissingPublications;
                                MavenPublication $this$invoke_u24lambda_u240 = (MavenPublication)object;
                                boolean bl = false;
                                $this$invoke_u24lambda_u240.from((SoftwareComponent)project.getComponents().getAt("kotlin"));
                                ProjectUtilsKt.log$default(project, "add js publication from kotlin component", null, 2, null);
                            }
                        }, arg_0));
                    }

                    private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                        $tmp0.invoke(p0);
                    }

                    private static final void invoke$lambda$1(Function1 $tmp0, Object p0) {
                        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                        $tmp0.invoke(p0);
                    }
                });
            }
        });
    }

    private final void lazilyConfigurePOM(Project $this$lazilyConfigurePOM) {
        this.configure($this$lazilyConfigurePOM, Reflection.getOrCreateKotlinClass(PublishingExtension.class), (Function1)new Function1<PublishingExtension, Unit>($this$lazilyConfigurePOM, this){
            final /* synthetic */ Project $this_lazilyConfigurePOM;
            final /* synthetic */ PublishOnMavenPlugin this$0;
            {
                this.$this_lazilyConfigurePOM = $receiver;
                this.this$0 = $receiver2;
                super(1);
            }

            public final void invoke(@NotNull PublishingExtension $this$configure) {
                Intrinsics.checkNotNullParameter((Object)$this$configure, (String)"$this$configure");
                this.$this_lazilyConfigurePOM.afterEvaluate(arg_0 -> lazilyConfigurePOM.1.invoke$lambda$0((Function1)new Function1<Project, Unit>($this$configure, this.this$0, this.$this_lazilyConfigurePOM){
                    final /* synthetic */ PublishingExtension $this_configure;
                    final /* synthetic */ PublishOnMavenPlugin this$0;
                    final /* synthetic */ Project $this_lazilyConfigurePOM;
                    {
                        this.$this_configure = $this_configure;
                        this.this$0 = $receiver;
                        this.$this_lazilyConfigurePOM = $receiver2;
                        super(1);
                    }

                    public final void invoke(Project project) {
                        this.$this_configure.getPublications().withType(MavenPublication.class, arg_0 -> lazilyConfigurePOM.1.invoke$lambda$0((Function1)new Function1<MavenPublication, Unit>(this.this$0, this.$this_lazilyConfigurePOM, project){
                            final /* synthetic */ PublishOnMavenPlugin this$0;
                            final /* synthetic */ Project $this_lazilyConfigurePOM;
                            final /* synthetic */ Project $project;
                            {
                                this.this$0 = $receiver;
                                this.$this_lazilyConfigurePOM = $receiver2;
                                this.$project = $project;
                                super(1);
                            }

                            public final void invoke(MavenPublication pub) {
                                Intrinsics.checkNotNullExpressionValue((Object)pub, (String)"pub");
                                this.this$0.copyMavenGroupAndVersionFromProject(this.$this_lazilyConfigurePOM, pub);
                                this.$project.getTasks().withType(Jar.class, arg_0 -> lazilyConfigurePOM.1.invoke$lambda$0((Function1)new Function1<Jar, Unit>(this.this$0, this.$this_lazilyConfigurePOM, pub){
                                    final /* synthetic */ PublishOnMavenPlugin this$0;
                                    final /* synthetic */ Project $this_lazilyConfigurePOM;
                                    final /* synthetic */ MavenPublication $pub;
                                    {
                                        this.this$0 = $receiver;
                                        this.$this_lazilyConfigurePOM = $receiver2;
                                        this.$pub = $pub;
                                        super(1);
                                    }

                                    public final void invoke(Jar it) {
                                        String string = this.this$0.getOptionalProperty(this.$this_lazilyConfigurePOM, "dokkaArtifactInMavenPublication");
                                        if (string == null) {
                                            string = "Html";
                                        }
                                        String suffix = string;
                                        String classifier = (String)it.getArchiveClassifier().getOrElse((Object)"");
                                        String string2 = it.getName();
                                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.name");
                                        if (StringsKt.contains((CharSequence)string2, (CharSequence)suffix, (boolean)true) && this.this$0.getPublishableClassifiers().contains((Object)classifier)) {
                                            this.$pub.artifact((Object)it);
                                            ProjectUtilsKt.log$default(this.$this_lazilyConfigurePOM, "add artifact to publication " + this.$pub.getName() + ": " + it.getArchiveFileName().get(), null, 2, null);
                                        }
                                    }
                                }, arg_0));
                                pub.pom(arg_0 -> lazilyConfigurePOM.1.invoke$lambda$1((Function1)new Function1<MavenPom, Unit>(this.this$0, this.$this_lazilyConfigurePOM, pub, this.$project){
                                    final /* synthetic */ PublishOnMavenPlugin this$0;
                                    final /* synthetic */ Project $this_lazilyConfigurePOM;
                                    final /* synthetic */ MavenPublication $pub;
                                    final /* synthetic */ Project $project;
                                    {
                                        this.this$0 = $receiver;
                                        this.$this_lazilyConfigurePOM = $receiver2;
                                        this.$pub = $pub;
                                        this.$project = $project;
                                        super(1);
                                    }

                                    public final void invoke(MavenPom pom) {
                                        String it;
                                        MavenPublication mavenPublication;
                                        Project project;
                                        String string;
                                        String string2 = this.this$0.getOptionalProperty(this.$this_lazilyConfigurePOM, "projectLongName");
                                        if (string2 != null) {
                                            string = string2;
                                            project = this.$this_lazilyConfigurePOM;
                                            mavenPublication = this.$pub;
                                            it = string;
                                            boolean bl = false;
                                            pom.getName().set((Object)it);
                                            ProjectUtilsKt.log$default(project, "set POM name in publication " + mavenPublication.getName() + ": " + it, null, 2, null);
                                        }
                                        String string3 = this.this$0.getOptionalProperty(this.$this_lazilyConfigurePOM, "projectDescription");
                                        if (string3 != null) {
                                            string = string3;
                                            project = this.$this_lazilyConfigurePOM;
                                            mavenPublication = this.$pub;
                                            it = string;
                                            boolean bl = false;
                                            pom.getDescription().set((Object)it);
                                            ProjectUtilsKt.log$default(project, "set POM description in publication " + mavenPublication.getName() + ": " + it, null, 2, null);
                                        }
                                        String string4 = this.this$0.getOptionalProperty(this.$this_lazilyConfigurePOM, "projectHomepage");
                                        if (string4 != null) {
                                            string = string4;
                                            project = this.$this_lazilyConfigurePOM;
                                            mavenPublication = this.$pub;
                                            it = string;
                                            boolean bl = false;
                                            pom.getUrl().set((Object)it);
                                            ProjectUtilsKt.log$default(project, "set POM URL in publication " + mavenPublication.getName() + ": " + it, null, 2, null);
                                        }
                                        pom.licenses(arg_0 -> lazilyConfigurePOM.2.invoke$lambda$3((Function1)new Function1<MavenPomLicenseSpec, Unit>(this.this$0, this.$this_lazilyConfigurePOM, this.$pub){
                                            final /* synthetic */ PublishOnMavenPlugin this$0;
                                            final /* synthetic */ Project $this_lazilyConfigurePOM;
                                            final /* synthetic */ MavenPublication $pub;
                                            {
                                                this.this$0 = $receiver;
                                                this.$this_lazilyConfigurePOM = $receiver2;
                                                this.$pub = $pub;
                                                super(1);
                                            }

                                            public final void invoke(MavenPomLicenseSpec licenses) {
                                                licenses.license(arg_0 -> lazilyConfigurePOM.4.invoke$lambda$0((Function1)new Function1<MavenPomLicense, Unit>(this.this$0, this.$this_lazilyConfigurePOM, this.$pub){
                                                    final /* synthetic */ PublishOnMavenPlugin this$0;
                                                    final /* synthetic */ Project $this_lazilyConfigurePOM;
                                                    final /* synthetic */ MavenPublication $pub;
                                                    {
                                                        this.this$0 = $receiver;
                                                        this.$this_lazilyConfigurePOM = $receiver2;
                                                        this.$pub = $pub;
                                                        super(1);
                                                    }

                                                    public final void invoke(MavenPomLicense license) {
                                                        block1: {
                                                            String it;
                                                            MavenPublication mavenPublication;
                                                            Project project;
                                                            String string;
                                                            String string2 = this.this$0.getOptionalProperty(this.$this_lazilyConfigurePOM, "projectLicense");
                                                            if (string2 != null) {
                                                                string = string2;
                                                                project = this.$this_lazilyConfigurePOM;
                                                                mavenPublication = this.$pub;
                                                                it = string;
                                                                boolean bl = false;
                                                                license.getName().set((Object)it);
                                                                ProjectUtilsKt.log$default(project, "add POM license in publication " + mavenPublication.getName() + ": " + it, null, 2, null);
                                                            }
                                                            String string3 = this.this$0.getOptionalProperty(this.$this_lazilyConfigurePOM, "projectLicenseUrl");
                                                            if (string3 == null) break block1;
                                                            string = string3;
                                                            project = this.$this_lazilyConfigurePOM;
                                                            mavenPublication = this.$pub;
                                                            it = string;
                                                            boolean bl = false;
                                                            license.getUrl().set((Object)it);
                                                            ProjectUtilsKt.log$default(project, "add POM license URL in publication " + mavenPublication.getName() + ": " + it, null, 2, null);
                                                        }
                                                    }
                                                }, arg_0));
                                            }

                                            private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                                                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                                                $tmp0.invoke(p0);
                                            }
                                        }, arg_0));
                                        pom.developers(arg_0 -> lazilyConfigurePOM.2.invoke$lambda$4((Function1)new Function1<MavenPomDeveloperSpec, Unit>(this.$project, this.$this_lazilyConfigurePOM, this.$pub){
                                            final /* synthetic */ Project $project;
                                            final /* synthetic */ Project $this_lazilyConfigurePOM;
                                            final /* synthetic */ MavenPublication $pub;
                                            {
                                                this.$project = $project;
                                                this.$this_lazilyConfigurePOM = $receiver;
                                                this.$pub = $pub;
                                                super(1);
                                            }

                                            public final void invoke(MavenPomDeveloperSpec devs) {
                                                Project project = this.$project;
                                                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                                                for (Developer dev : Developer.Companion.getAllDevs(project)) {
                                                    Intrinsics.checkNotNullExpressionValue((Object)devs, (String)"devs");
                                                    dev.applyTo(devs);
                                                    ProjectUtilsKt.log$default(this.$this_lazilyConfigurePOM, "add POM developer publication " + this.$pub.getName() + ": " + dev, null, 2, null);
                                                }
                                            }
                                        }, arg_0));
                                        pom.scm(arg_0 -> lazilyConfigurePOM.2.invoke$lambda$5((Function1)new Function1<MavenPomScm, Unit>(this.this$0, this.$this_lazilyConfigurePOM, this.$pub){
                                            final /* synthetic */ PublishOnMavenPlugin this$0;
                                            final /* synthetic */ Project $this_lazilyConfigurePOM;
                                            final /* synthetic */ MavenPublication $pub;
                                            {
                                                this.this$0 = $receiver;
                                                this.$this_lazilyConfigurePOM = $receiver2;
                                                this.$pub = $pub;
                                                super(1);
                                            }

                                            public final void invoke(MavenPomScm scm) {
                                                block1: {
                                                    String it;
                                                    MavenPublication mavenPublication;
                                                    Project project;
                                                    String string;
                                                    String string2 = this.this$0.getOptionalProperty(this.$this_lazilyConfigurePOM, "scmConnection");
                                                    if (string2 != null) {
                                                        string = string2;
                                                        project = this.$this_lazilyConfigurePOM;
                                                        mavenPublication = this.$pub;
                                                        it = string;
                                                        boolean bl = false;
                                                        scm.getConnection().set((Object)it);
                                                        ProjectUtilsKt.log$default(project, "add POM SCM connection in publication " + mavenPublication.getName() + ": " + it, null, 2, null);
                                                    }
                                                    String string3 = this.this$0.getOptionalProperty(this.$this_lazilyConfigurePOM, "scmUrl");
                                                    if (string3 == null) break block1;
                                                    string = string3;
                                                    project = this.$this_lazilyConfigurePOM;
                                                    mavenPublication = this.$pub;
                                                    it = string;
                                                    boolean bl = false;
                                                    scm.getUrl().set((Object)it);
                                                    ProjectUtilsKt.log$default(project, "add POM SCM URL in publication " + mavenPublication.getName() + ": " + it, null, 2, null);
                                                }
                                            }
                                        }, arg_0));
                                    }

                                    private static final void invoke$lambda$3(Function1 $tmp0, Object p0) {
                                        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                                        $tmp0.invoke(p0);
                                    }

                                    private static final void invoke$lambda$4(Function1 $tmp0, Object p0) {
                                        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                                        $tmp0.invoke(p0);
                                    }

                                    private static final void invoke$lambda$5(Function1 $tmp0, Object p0) {
                                        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                                        $tmp0.invoke(p0);
                                    }
                                }, arg_0));
                            }

                            private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                                $tmp0.invoke(p0);
                            }

                            private static final void invoke$lambda$1(Function1 $tmp0, Object p0) {
                                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                                $tmp0.invoke(p0);
                            }
                        }, arg_0));
                    }

                    private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                        $tmp0.invoke(p0);
                    }
                }, arg_0));
            }

            private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }
        });
    }

    @Override
    protected void applyThisPlugin(@NotNull Project $this$applyThisPlugin) {
        Intrinsics.checkNotNullParameter((Object)$this$applyThisPlugin, (String)"<this>");
        DomainObjectSet domainObjectSet = $this$applyThisPlugin.getProject().getObjects().domainObjectSet(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)domainObjectSet, (String)"project.objects.domainOb\u2026ctSet(String::class.java)");
        this.setPublishableClassifiers((DomainObjectSet<String>)domainObjectSet);
        this.getPublishableClassifiers().add((Object)"javadoc");
        PluginAwareExtensionsKt.apply$default((PluginAware)((PluginAware)$this$applyThisPlugin), null, (String)"maven-publish", null, (int)5, null);
        ProjectUtilsKt.log$default($this$applyThisPlugin, "apply maven-publish plugin", null, 2, null);
        PluginAwareExtensionsKt.apply$default((PluginAware)((PluginAware)$this$applyThisPlugin), null, (String)"signing", null, (int)5, null);
        ProjectUtilsKt.log$default($this$applyThisPlugin, "apply signing plugin", null, 2, null);
        this.configureMavenRepository($this$applyThisPlugin);
        this.addMissingPublications($this$applyThisPlugin);
        this.lazilyConfigurePOM($this$applyThisPlugin);
        this.configureSigning($this$applyThisPlugin);
    }
}

