/*
 * Decompiled with CFR 0.152.
 */
package io.github.gciatto.kt.node;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.gciatto.kt.node.AbstractNodeDefaultTask;
import io.github.gciatto.kt.node.NpmPublishExtension;
import io.github.gciatto.kt.node.PackageJson;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0015H\u0007J\b\u0010\u0019\u001a\u00020\u0015H\u0002J\b\u0010\u001a\u001a\u00020\u0015H\u0002J\b\u0010\u001b\u001a\u00020\u0015H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e8\u0004X\u0085\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/github/gciatto/kt/node/LiftPackageJsonTask;", "Lio/github/gciatto/kt/node/AbstractNodeDefaultTask;", "()V", "actualPackageJsonFile", "Ljava/io/File;", "gson", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "liftingActions", "Lorg/gradle/api/provider/ListProperty;", "Lorg/gradle/api/Action;", "Lio/github/gciatto/kt/node/PackageJson;", "packageJson", "packageJsonFile", "Lorg/gradle/api/provider/Property;", "getPackageJsonFile", "()Lorg/gradle/api/provider/Property;", "packageJsonRaw", "Lcom/google/gson/JsonObject;", "rawLiftingActions", "defaultValuesFrom", "", "extension", "Lio/github/gciatto/kt/node/NpmPublishExtension;", "lift", "performLifting", "resolve", "save", "kt-npm-publish"})
public class LiftPackageJsonTask
extends AbstractNodeDefaultTask {
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    @Input
    @NotNull
    private final Property<File> packageJsonFile;
    @Nullable
    private PackageJson packageJson;
    private JsonObject packageJsonRaw;
    @NotNull
    private final ListProperty<Action<PackageJson>> liftingActions;
    @NotNull
    private final ListProperty<Action<JsonObject>> rawLiftingActions;
    private File actualPackageJsonFile;

    public LiftPackageJsonTask() {
        ObjectFactory $this$listProperty$iv;
        ObjectFactory $this$property$iv;
        ObjectFactory objectFactory = this.getProject().getObjects();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory, (String)"project.objects");
        boolean $i$f$property = false;
        Property property = $this$property$iv.property(File.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property(T::class.java)");
        this.packageJsonFile = property;
        $this$property$iv = this.getProject().getObjects();
        Intrinsics.checkNotNullExpressionValue((Object)$this$property$iv, (String)"project.objects");
        boolean $i$f$listProperty = false;
        ListProperty listProperty = $this$listProperty$iv.listProperty(Action.class);
        Intrinsics.checkNotNullExpressionValue((Object)listProperty, (String)"listProperty(T::class.java)");
        this.liftingActions = listProperty;
        $this$listProperty$iv = this.getProject().getObjects();
        Intrinsics.checkNotNullExpressionValue((Object)$this$listProperty$iv, (String)"project.objects");
        $i$f$listProperty = false;
        ListProperty listProperty2 = $this$listProperty$iv.listProperty(Action.class);
        Intrinsics.checkNotNullExpressionValue((Object)listProperty2, (String)"listProperty(T::class.java)");
        this.rawLiftingActions = listProperty2;
    }

    @NotNull
    protected final Property<File> getPackageJsonFile() {
        return this.packageJsonFile;
    }

    @Override
    public void defaultValuesFrom(@NotNull NpmPublishExtension extension) {
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        super.defaultValuesFrom(extension);
        this.packageJsonFile.set((Provider)extension.getPackageJson());
        this.liftingActions.set((Provider)extension.getPackageJsonLiftingActions$kt_npm_publish());
        this.rawLiftingActions.set((Provider)extension.getPackageJsonRawLiftingActions$kt_npm_publish());
    }

    @TaskAction
    public final void lift() {
        Object object = this.packageJsonFile.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"packageJsonFile.get()");
        this.actualPackageJsonFile = (File)object;
        object = this.actualPackageJsonFile;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"actualPackageJsonFile");
            throw null;
        }
        if (!((File)object).exists()) {
            File file = this.actualPackageJsonFile;
            if (file == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"actualPackageJsonFile");
                throw null;
            }
            object = file.getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"actualPackageJsonFile.parentFile");
            this.actualPackageJsonFile = FilesKt.resolve((File)object, (String)"pre-package.json");
        }
        if ((object = this.actualPackageJsonFile) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"actualPackageJsonFile");
            throw null;
        }
        if (!((File)object).exists()) {
            object = "File " + ((File)this.packageJsonFile.get()).getPath() + " does not exist";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        this.resolve();
        this.performLifting();
        this.save();
    }

    private final void resolve() {
        LiftPackageJsonTask liftPackageJsonTask;
        File file = this.actualPackageJsonFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"actualPackageJsonFile");
            throw null;
        }
        Object object = this.gson.fromJson((Reader)new FileReader(file), JsonObject.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"gson.fromJson(FileReader(actualPackageJsonFile), JsonObject::class.java)");
        this.packageJsonRaw = (JsonObject)object;
        LiftPackageJsonTask liftPackageJsonTask2 = this;
        try {
            liftPackageJsonTask = liftPackageJsonTask2;
            object = this.packageJsonRaw;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"packageJsonRaw");
                throw null;
            }
            object = PackageJson.Companion.fromJson((JsonElement)object);
        }
        catch (Throwable throwable) {
            liftPackageJsonTask = liftPackageJsonTask2;
            File file2 = this.actualPackageJsonFile;
            if (file2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"actualPackageJsonFile");
                throw null;
            }
            System.err.println("Cannot parse " + file2 + " as a data class, use raw lifting");
            object = null;
        }
        liftPackageJsonTask.packageJson = object;
    }

    private final void performLifting() {
        if (this.packageJson == null) {
            Object object = this.rawLiftingActions.getOrElse((Object)CollectionsKt.emptyList());
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"rawLiftingActions.getOrElse(emptyList())");
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Action it = (Action)element$iv;
                boolean bl = false;
                JsonObject jsonObject = this.packageJsonRaw;
                if (jsonObject == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"packageJsonRaw");
                    throw null;
                }
                it.execute((Object)jsonObject);
            }
        } else {
            Object $this$forEach$iv = this.liftingActions.getOrElse((Object)CollectionsKt.emptyList());
            Intrinsics.checkNotNullExpressionValue((Object)$this$forEach$iv, (String)"liftingActions.getOrElse(emptyList())");
            $this$forEach$iv = (Iterable)$this$forEach$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv = iterator.next();
                Action it = (Action)element$iv;
                boolean bl = false;
                PackageJson packageJson = this.packageJson;
                Intrinsics.checkNotNull((Object)packageJson);
                it.execute((Object)packageJson);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void save() {
        File file = this.actualPackageJsonFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"actualPackageJsonFile");
            throw null;
        }
        Object object = file.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"actualPackageJsonFile.parentFile");
        object = new FileWriter(FilesKt.resolve((File)object, (String)"package.json"));
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            Object object2;
            JsonObject jsonObject;
            FileWriter it = (FileWriter)object;
            boolean bl3 = false;
            PackageJson packageJson = this.packageJson;
            JsonObject jsonObject2 = jsonObject = packageJson == null ? null : packageJson.toJson();
            if (jsonObject == null) {
                packageJson = this.packageJsonRaw;
                if (packageJson == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"packageJsonRaw");
                    throw null;
                }
                object2 = packageJson;
            } else {
                object2 = jsonObject;
            }
            this.gson.toJson((JsonElement)object2, (Appendable)it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }
}

