/*
 * Decompiled with CFR 0.152.
 */
package com.genius.multiprogressbar;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.LinearInterpolator;
import androidx.annotation.FloatRange;
import com.genius.multiprogressbar.R;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0014\u0018\u0000 D2\u00020\u0001:\u0003DEFB%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010!\u001a\u00020\"J\u0006\u0010#\u001a\u00020\u0007J\u0006\u0010$\u001a\u00020\u0007J\u0006\u0010%\u001a\u00020\u0007J\u0006\u0010&\u001a\u00020\fJ\u0010\u0010'\u001a\u00020\"2\u0006\u0010(\u001a\u00020\u0007H\u0002J\b\u0010)\u001a\u00020\"H\u0002J\u0006\u0010*\u001a\u00020\"J\u0010\u0010+\u001a\u00020\"2\u0006\u0010,\u001a\u00020-H\u0014J\u0018\u0010.\u001a\u00020\"2\u0006\u0010/\u001a\u00020\u00072\u0006\u00100\u001a\u00020\u0007H\u0014J\u0012\u00101\u001a\u00020\"2\b\u00102\u001a\u0004\u0018\u000103H\u0014J\n\u00104\u001a\u0004\u0018\u000103H\u0014J(\u00105\u001a\u00020\"2\u0006\u00106\u001a\u00020\u00072\u0006\u00107\u001a\u00020\u00072\u0006\u00108\u001a\u00020\u00072\u0006\u00109\u001a\u00020\u0007H\u0014J\u0006\u0010:\u001a\u00020\"J\u0006\u0010;\u001a\u00020\"J\u0010\u0010<\u001a\u00020\"2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ\u000e\u0010=\u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\u0007J\u000e\u0010>\u001a\u00020\"2\u0006\u0010?\u001a\u00020\u0007J\u0010\u0010@\u001a\u00020\"2\b\b\u0001\u0010\u001a\u001a\u00020\fJ\u0006\u0010A\u001a\u00020\"J\f\u0010B\u001a\u00020\"*\u00020\u0015H\u0002J\f\u0010C\u001a\u00020\"*\u00020\u0015H\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001e\u001a\u00020\f*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006G"}, d2={"Lcom/genius/multiprogressbar/MultiProgressBar;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attributeSet", "Landroid/util/AttributeSet;", "defStyle", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "activeAnimator", "Landroid/animation/ValueAnimator;", "animatedAbsoluteProgress", "", "countOfProgressSteps", "currentAbsoluteProgress", "displayedStepForListener", "isNeedRestoreProgressAfterRecreate", "", "isProgressIsRunning", "lineColor", "paint", "Landroid/graphics/Paint;", "progressColor", "progressPadding", "progressPercents", "progressWidth", "singleDisplayedTime", "singleProgressWidth", "stepChangeListener", "Lcom/genius/multiprogressbar/MultiProgressBar$ProgressStepChangeListener;", "toPx", "getToPx", "(F)F", "clear", "", "getCurrentStep", "getProgressPercents", "getProgressStepsCount", "getSingleDisplayTime", "internalSetProgressStepsCount", "count", "internalStartProgress", "next", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onRestoreInstanceState", "state", "Landroid/os/Parcelable;", "onSaveInstanceState", "onSizeChanged", "w", "h", "oldw", "oldh", "pause", "previous", "setListener", "setProgressPercents", "setProgressStepsCount", "progressSteps", "setSingleDisplayTime", "start", "changePaintModeToBackground", "changePaintModeToProgress", "Companion", "MultiProgressBarSavedState", "ProgressStepChangeListener", "multiprogressbar_release"})
public final class MultiProgressBar
extends View {
    private final Paint paint;
    private int progressColor;
    private int lineColor;
    private float progressPadding;
    private float progressWidth;
    private float singleProgressWidth;
    private int countOfProgressSteps;
    private boolean isNeedRestoreProgressAfterRecreate;
    private float singleDisplayedTime;
    private ProgressStepChangeListener stepChangeListener;
    private int progressPercents;
    private float currentAbsoluteProgress;
    private float animatedAbsoluteProgress;
    private boolean isProgressIsRunning;
    private int displayedStepForListener;
    private ValueAnimator activeAnimator;
    private static final float MIN_PADDING = 8.0f;
    @NotNull
    public static final Companion Companion = new Companion(null);

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int n;
        int n2;
        int desiredWidth = 100;
        int desiredHeight = (int)this.progressWidth + 5;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        switch (widthMode) {
            case 0x40000000: {
                n2 = widthSize;
                break;
            }
            case -2147483648: {
                boolean bl = false;
                n2 = Math.min(desiredWidth, widthSize);
                break;
            }
            case 0: {
                n2 = desiredWidth;
                break;
            }
            default: {
                n2 = desiredWidth;
            }
        }
        int width = n2;
        switch (heightMode) {
            case 0x40000000: {
                n = heightSize;
                break;
            }
            case -2147483648: {
                boolean bl = false;
                n = Math.min(desiredHeight, heightSize);
                break;
            }
            case 0: {
                n = desiredHeight;
                break;
            }
            default: {
                n = desiredHeight;
            }
        }
        int height = n;
        this.setMeasuredDimension(width, height);
    }

    @Nullable
    protected Parcelable onSaveInstanceState() {
        Parcelable parcelable = super.onSaveInstanceState();
        if (parcelable == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)parcelable, (String)"super.onSaveInstanceState() ?: return null");
        Parcelable superState = parcelable;
        MultiProgressBarSavedState multiProgressBarSavedState = new MultiProgressBarSavedState(superState);
        boolean bl = false;
        boolean bl2 = false;
        MultiProgressBarSavedState $this$apply = multiProgressBarSavedState;
        boolean bl3 = false;
        $this$apply.setProgressColor(this.progressColor);
        $this$apply.setLineColor(this.lineColor);
        $this$apply.setCountProgress(this.countOfProgressSteps);
        $this$apply.setProgressPercents(this.progressPercents);
        $this$apply.setProgressPadding(this.progressPadding);
        $this$apply.setProgressWidth(this.progressWidth);
        $this$apply.setSingleProgressWidth(this.singleProgressWidth);
        $this$apply.setCurrentAbsoluteProgress(this.currentAbsoluteProgress);
        $this$apply.setAnimatedAbsoluteProgress(this.animatedAbsoluteProgress);
        $this$apply.setProgressIsRunning(this.isProgressIsRunning);
        $this$apply.setDisplayedStepForListener(this.displayedStepForListener);
        $this$apply.setNeedRestoreProgressAfterRecreate(this.isNeedRestoreProgressAfterRecreate);
        $this$apply.setSingleDisplayedTime(this.singleDisplayedTime);
        return (Parcelable)multiProgressBarSavedState;
    }

    protected void onRestoreInstanceState(@Nullable Parcelable state) {
        if (!(state instanceof MultiProgressBarSavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        super.onRestoreInstanceState(((MultiProgressBarSavedState)state).getSuperState());
        this.progressColor = ((MultiProgressBarSavedState)state).getProgressColor();
        this.lineColor = ((MultiProgressBarSavedState)state).getLineColor();
        this.countOfProgressSteps = ((MultiProgressBarSavedState)state).getCountProgress();
        this.progressPercents = ((MultiProgressBarSavedState)state).getProgressPercents();
        this.progressPadding = ((MultiProgressBarSavedState)state).getProgressPadding();
        this.progressWidth = ((MultiProgressBarSavedState)state).getProgressWidth();
        this.singleProgressWidth = ((MultiProgressBarSavedState)state).getSingleProgressWidth();
        this.currentAbsoluteProgress = ((MultiProgressBarSavedState)state).getCurrentAbsoluteProgress();
        this.animatedAbsoluteProgress = ((MultiProgressBarSavedState)state).getAnimatedAbsoluteProgress();
        this.displayedStepForListener = ((MultiProgressBarSavedState)state).getDisplayedStepForListener();
        this.isNeedRestoreProgressAfterRecreate = ((MultiProgressBarSavedState)state).isNeedRestoreProgressAfterRecreate();
        this.isProgressIsRunning = ((MultiProgressBarSavedState)state).isProgressIsRunning();
        this.singleDisplayedTime = ((MultiProgressBarSavedState)state).getSingleDisplayedTime();
        if (this.isProgressIsRunning && this.isNeedRestoreProgressAfterRecreate) {
            this.pause();
            this.internalStartProgress();
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.internalSetProgressStepsCount(this.countOfProgressSteps);
    }

    /*
     * WARNING - void declaration
     */
    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        int n = 0;
        int n2 = this.countOfProgressSteps;
        while (n < n2) {
            float endX;
            void step;
            float previousPaddingSum = this.progressPadding + this.progressPadding * (float)step;
            float startX = previousPaddingSum + this.singleProgressWidth * (float)step;
            float f = endX = step == this.countOfProgressSteps - 1 ? (float)this.getMeasuredWidth() - this.progressPadding : startX + this.singleProgressWidth;
            if ((float)step > this.currentAbsoluteProgress / (float)this.progressPercents - 1.0f) {
                this.changePaintModeToBackground(this.paint);
            } else {
                this.changePaintModeToProgress(this.paint);
            }
            canvas.drawLine(startX, (float)this.getMeasuredHeight() / 2.0f, endX, (float)this.getMeasuredHeight() / 2.0f, this.paint);
            float progressMultiplier = this.currentAbsoluteProgress / (float)this.progressPercents - (float)step;
            if (progressMultiplier < 1.0f && progressMultiplier > 0.0f) {
                float progressEndX = startX + this.singleProgressWidth * progressMultiplier;
                this.changePaintModeToProgress(this.paint);
                canvas.drawLine(startX, (float)this.getMeasuredHeight() / 2.0f, progressEndX, (float)this.getMeasuredHeight() / 2.0f, this.paint);
            }
            ++step;
        }
    }

    public final void setListener(@Nullable ProgressStepChangeListener stepChangeListener) {
        this.stepChangeListener = stepChangeListener;
    }

    public final void setProgressStepsCount(int progressSteps) {
        this.internalSetProgressStepsCount(progressSteps);
    }

    public final int getProgressStepsCount() {
        return this.countOfProgressSteps;
    }

    public final void start() {
        if (this.isProgressIsRunning) {
            return;
        }
        this.pause();
        this.internalStartProgress();
    }

    public final void pause() {
        ValueAnimator valueAnimator = this.activeAnimator;
        if (valueAnimator != null) {
            valueAnimator.removeAllUpdateListeners();
        }
        ValueAnimator valueAnimator2 = this.activeAnimator;
        if (valueAnimator2 != null) {
            valueAnimator2.cancel();
        }
        this.isProgressIsRunning = false;
    }

    public final void next() {
        if (this.isProgressIsRunning) {
            this.pause();
            int currentStep = (int)(this.currentAbsoluteProgress / (float)this.progressPercents);
            this.animatedAbsoluteProgress = this.currentAbsoluteProgress = RangesKt.coerceAtMost((float)((float)currentStep + 1.0f), (float)this.countOfProgressSteps) * (float)this.progressPercents;
            this.start();
        } else {
            int currentStep = (int)(this.currentAbsoluteProgress / (float)this.progressPercents);
            this.animatedAbsoluteProgress = this.currentAbsoluteProgress = RangesKt.coerceAtMost((float)((float)currentStep + 1.0f), (float)this.countOfProgressSteps) * (float)this.progressPercents;
            this.invalidate();
        }
    }

    public final void previous() {
        if (this.isProgressIsRunning) {
            this.pause();
            int currentStep = (int)(this.currentAbsoluteProgress / (float)this.progressPercents);
            this.animatedAbsoluteProgress = this.currentAbsoluteProgress = RangesKt.coerceAtLeast((float)((float)currentStep - 1.0f), (float)0.0f) * (float)this.progressPercents;
            this.start();
        } else {
            int currentStep = (int)(this.currentAbsoluteProgress / (float)this.progressPercents);
            this.animatedAbsoluteProgress = this.currentAbsoluteProgress = RangesKt.coerceAtLeast((float)((float)currentStep - 1.0f), (float)0.0f) * (float)this.progressPercents;
            this.invalidate();
        }
    }

    public final void clear() {
        if (this.isProgressIsRunning) {
            this.pause();
        }
        this.currentAbsoluteProgress = 0.0f;
        this.animatedAbsoluteProgress = 0.0f;
        this.displayedStepForListener = -1;
        this.invalidate();
    }

    public final int getCurrentStep() {
        return (int)(this.currentAbsoluteProgress / (float)this.progressPercents);
    }

    public final void setProgressPercents(int progressPercents) {
        this.progressPercents = progressPercents;
    }

    public final int getProgressPercents() {
        return this.progressPercents;
    }

    public final void setSingleDisplayTime(@FloatRange(from=0.1) float singleDisplayedTime) {
        this.singleDisplayedTime = RangesKt.coerceAtLeast((float)singleDisplayedTime, (float)0.1f);
        if (this.isProgressIsRunning) {
            new Handler(Looper.getMainLooper()).post(new Runnable(this){
                final /* synthetic */ MultiProgressBar this$0;

                public final void run() {
                    this.this$0.pause();
                    MultiProgressBar.access$internalStartProgress(this.this$0);
                }
                {
                    this.this$0 = multiProgressBar;
                }
            });
        }
    }

    public final float getSingleDisplayTime() {
        return this.singleDisplayedTime;
    }

    /*
     * WARNING - void declaration
     */
    private final void internalStartProgress() {
        block0: {
            void $this$apply;
            float maxValue = (float)this.countOfProgressSteps * (float)this.progressPercents;
            ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{this.animatedAbsoluteProgress, maxValue});
            boolean bl = false;
            boolean bl2 = false;
            ValueAnimator valueAnimator2 = valueAnimator;
            MultiProgressBar multiProgressBar = this;
            boolean bl3 = false;
            $this$apply.setDuration((long)(this.singleDisplayedTime * (float)1000 * (float)this.countOfProgressSteps * (1.0f - this.animatedAbsoluteProgress / maxValue)));
            $this$apply.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this, maxValue){
                final /* synthetic */ MultiProgressBar this$0;
                final /* synthetic */ float $maxValue$inlined;
                {
                    this.this$0 = multiProgressBar;
                    this.$maxValue$inlined = f;
                }

                public final void onAnimationUpdate(ValueAnimator animator) {
                    ValueAnimator valueAnimator = animator;
                    Intrinsics.checkNotNullExpressionValue((Object)valueAnimator, (String)"animator");
                    Object object = valueAnimator.getAnimatedValue();
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                    }
                    float value = ((Float)object).floatValue();
                    MultiProgressBar.access$setProgressIsRunning$p(this.this$0, value != this.$maxValue$inlined);
                    if ((int)(value / (float)MultiProgressBar.access$getProgressPercents$p(this.this$0)) != MultiProgressBar.access$getDisplayedStepForListener$p(this.this$0)) {
                        MultiProgressBar.access$setDisplayedStepForListener$p(this.this$0, (int)(value / (float)MultiProgressBar.access$getProgressPercents$p(this.this$0)));
                        ProgressStepChangeListener progressStepChangeListener = MultiProgressBar.access$getStepChangeListener$p(this.this$0);
                        if (progressStepChangeListener != null) {
                            progressStepChangeListener.onProgressStepChange(MultiProgressBar.access$getDisplayedStepForListener$p(this.this$0));
                        }
                    }
                    if (MultiProgressBar.access$isProgressIsRunning$p(this.this$0)) {
                        MultiProgressBar.access$setCurrentAbsoluteProgress$p(this.this$0, RangesKt.coerceAtMost((float)value, (float)((float)MultiProgressBar.access$getCountOfProgressSteps$p(this.this$0) * (float)MultiProgressBar.access$getProgressPercents$p(this.this$0))));
                        this.this$0.invalidate();
                        MultiProgressBar.access$setAnimatedAbsoluteProgress$p(this.this$0, value);
                    } else {
                        animator.removeAllUpdateListeners();
                        MultiProgressBar.access$setAnimatedAbsoluteProgress$p(this.this$0, 0.0f);
                        MultiProgressBar.access$setDisplayedStepForListener$p(this.this$0, -1);
                    }
                }
            });
            $this$apply.setInterpolator((TimeInterpolator)new LinearInterpolator());
            Unit unit = Unit.INSTANCE;
            multiProgressBar.activeAnimator = valueAnimator;
            ValueAnimator valueAnimator3 = this.activeAnimator;
            if (valueAnimator3 == null) break block0;
            valueAnimator3.start();
        }
    }

    private final void internalSetProgressStepsCount(int count) {
        this.countOfProgressSteps = count;
        this.singleProgressWidth = ((float)this.getMeasuredWidth() - this.progressPadding * (float)this.countOfProgressSteps - this.progressPadding) / (float)this.countOfProgressSteps;
        boolean bl = this.getMeasuredWidth() == 0 || !(this.singleProgressWidth < 0.0f);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "There is not enough space to draw a MultiProgressBar";
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    private final void changePaintModeToProgress(Paint $this$changePaintModeToProgress) {
        $this$changePaintModeToProgress.reset();
        $this$changePaintModeToProgress.setStrokeCap(Paint.Cap.ROUND);
        $this$changePaintModeToProgress.setStrokeWidth(this.progressWidth);
        $this$changePaintModeToProgress.setStyle(Paint.Style.STROKE);
        $this$changePaintModeToProgress.setDither(true);
        $this$changePaintModeToProgress.setAntiAlias(true);
        $this$changePaintModeToProgress.setColor(this.progressColor);
    }

    private final void changePaintModeToBackground(Paint $this$changePaintModeToBackground) {
        $this$changePaintModeToBackground.reset();
        $this$changePaintModeToBackground.setStrokeCap(Paint.Cap.ROUND);
        $this$changePaintModeToBackground.setStrokeWidth(this.progressWidth);
        $this$changePaintModeToBackground.setStyle(Paint.Style.STROKE);
        $this$changePaintModeToBackground.setDither(true);
        $this$changePaintModeToBackground.setAntiAlias(true);
        $this$changePaintModeToBackground.setColor(this.lineColor);
    }

    private final float getToPx(float $this$toPx) {
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"context.resources");
        return $this$toPx * resources.getDisplayMetrics().density;
    }

    @JvmOverloads
    public MultiProgressBar(@NotNull Context context, @Nullable AttributeSet attributeSet, int defStyle) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attributeSet, defStyle);
        this.paint = new Paint();
        this.progressWidth = 10.0f;
        this.countOfProgressSteps = 1;
        this.singleDisplayedTime = 1.0f;
        this.displayedStepForListener = -1;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.MultiProgressBar);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.obtainStyledAttr\u2026yleable.MultiProgressBar)");
        TypedArray typedArray2 = typedArray;
        this.lineColor = typedArray2.getColor(R.styleable.MultiProgressBar_lineColor, -7829368);
        this.progressColor = typedArray2.getColor(R.styleable.MultiProgressBar_progressColor, -1);
        this.progressPadding = typedArray2.getDimension(R.styleable.MultiProgressBar_progressPadding, this.getToPx(8.0f));
        this.countOfProgressSteps = typedArray2.getInt(R.styleable.MultiProgressBar_progressSteps, 1);
        this.progressWidth = typedArray2.getDimension(R.styleable.MultiProgressBar_progressWidth, 10.0f);
        this.progressPercents = typedArray2.getInt(R.styleable.MultiProgressBar_progressPercents, 100);
        this.isNeedRestoreProgressAfterRecreate = typedArray2.getBoolean(R.styleable.MultiProgressBar_isNeedRestoreProgress, false);
        this.singleDisplayedTime = RangesKt.coerceAtLeast((float)typedArray2.getFloat(R.styleable.MultiProgressBar_singleDisplayedTime, 1.0f), (float)0.1f);
        typedArray2.recycle();
        if (this.isInEditMode()) {
            this.currentAbsoluteProgress = (float)this.countOfProgressSteps / 2.0f * (float)this.progressPercents;
        }
    }

    public /* synthetic */ MultiProgressBar(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public MultiProgressBar(@NotNull Context context, @Nullable AttributeSet attributeSet) {
        this(context, attributeSet, 0, 4, null);
    }

    @JvmOverloads
    public MultiProgressBar(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    public static final /* synthetic */ void access$internalStartProgress(MultiProgressBar $this) {
        $this.internalStartProgress();
    }

    public static final /* synthetic */ boolean access$isProgressIsRunning$p(MultiProgressBar $this) {
        return $this.isProgressIsRunning;
    }

    public static final /* synthetic */ void access$setProgressIsRunning$p(MultiProgressBar $this, boolean bl) {
        $this.isProgressIsRunning = bl;
    }

    public static final /* synthetic */ int access$getDisplayedStepForListener$p(MultiProgressBar $this) {
        return $this.displayedStepForListener;
    }

    public static final /* synthetic */ void access$setDisplayedStepForListener$p(MultiProgressBar $this, int n) {
        $this.displayedStepForListener = n;
    }

    public static final /* synthetic */ int access$getProgressPercents$p(MultiProgressBar $this) {
        return $this.progressPercents;
    }

    public static final /* synthetic */ void access$setProgressPercents$p(MultiProgressBar $this, int n) {
        $this.progressPercents = n;
    }

    public static final /* synthetic */ ProgressStepChangeListener access$getStepChangeListener$p(MultiProgressBar $this) {
        return $this.stepChangeListener;
    }

    public static final /* synthetic */ void access$setStepChangeListener$p(MultiProgressBar $this, ProgressStepChangeListener progressStepChangeListener) {
        $this.stepChangeListener = progressStepChangeListener;
    }

    public static final /* synthetic */ float access$getCurrentAbsoluteProgress$p(MultiProgressBar $this) {
        return $this.currentAbsoluteProgress;
    }

    public static final /* synthetic */ void access$setCurrentAbsoluteProgress$p(MultiProgressBar $this, float f) {
        $this.currentAbsoluteProgress = f;
    }

    public static final /* synthetic */ int access$getCountOfProgressSteps$p(MultiProgressBar $this) {
        return $this.countOfProgressSteps;
    }

    public static final /* synthetic */ void access$setCountOfProgressSteps$p(MultiProgressBar $this, int n) {
        $this.countOfProgressSteps = n;
    }

    public static final /* synthetic */ float access$getAnimatedAbsoluteProgress$p(MultiProgressBar $this) {
        return $this.animatedAbsoluteProgress;
    }

    public static final /* synthetic */ void access$setAnimatedAbsoluteProgress$p(MultiProgressBar $this, float f) {
        $this.animatedAbsoluteProgress = f;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/genius/multiprogressbar/MultiProgressBar$ProgressStepChangeListener;", "", "onProgressStepChange", "", "newStep", "", "multiprogressbar_release"})
    public static interface ProgressStepChangeListener {
        public void onProgressStepChange(int var1);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u001c\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000 ;2\u00020\u0001:\u0001;B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0012\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u00106\u001a\u00020\u000fH\u0016J\u0018\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\u00062\u0006\u0010:\u001a\u00020\u000fH\u0016R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u000b\"\u0004\b\u0016\u0010\rR\u001a\u0010\u0017\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0011\"\u0004\b\u0019\u0010\u0013R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001c\"\u0004\b \u0010\u001eR\u001a\u0010!\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0011\"\u0004\b#\u0010\u0013R\u001a\u0010$\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u0011\"\u0004\b&\u0010\u0013R\u001a\u0010'\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u000b\"\u0004\b)\u0010\rR\u001a\u0010*\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u0011\"\u0004\b,\u0010\u0013R\u001a\u0010-\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\u000b\"\u0004\b/\u0010\rR\u001a\u00100\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010\u000b\"\u0004\b2\u0010\rR\u001a\u00103\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010\u000b\"\u0004\b5\u0010\r\u00a8\u0006<"}, d2={"Lcom/genius/multiprogressbar/MultiProgressBar$MultiProgressBarSavedState;", "Landroid/view/View$BaseSavedState;", "superState", "Landroid/os/Parcelable;", "(Landroid/os/Parcelable;)V", "in", "Landroid/os/Parcel;", "(Landroid/os/Parcel;)V", "animatedAbsoluteProgress", "", "getAnimatedAbsoluteProgress", "()F", "setAnimatedAbsoluteProgress", "(F)V", "countProgress", "", "getCountProgress", "()I", "setCountProgress", "(I)V", "currentAbsoluteProgress", "getCurrentAbsoluteProgress", "setCurrentAbsoluteProgress", "displayedStepForListener", "getDisplayedStepForListener", "setDisplayedStepForListener", "isNeedRestoreProgressAfterRecreate", "", "()Z", "setNeedRestoreProgressAfterRecreate", "(Z)V", "isProgressIsRunning", "setProgressIsRunning", "lineColor", "getLineColor", "setLineColor", "progressColor", "getProgressColor", "setProgressColor", "progressPadding", "getProgressPadding", "setProgressPadding", "progressPercents", "getProgressPercents", "setProgressPercents", "progressWidth", "getProgressWidth", "setProgressWidth", "singleDisplayedTime", "getSingleDisplayedTime", "setSingleDisplayedTime", "singleProgressWidth", "getSingleProgressWidth", "setSingleProgressWidth", "describeContents", "writeToParcel", "", "out", "flags", "CREATOR", "multiprogressbar_release"})
    private static final class MultiProgressBarSavedState
    extends View.BaseSavedState {
        private int progressColor;
        private int lineColor;
        private float progressPadding;
        private float progressWidth;
        private float singleProgressWidth;
        private float animatedAbsoluteProgress;
        private float currentAbsoluteProgress;
        private int countProgress;
        private int progressPercents;
        private int displayedStepForListener;
        private boolean isProgressIsRunning;
        private boolean isNeedRestoreProgressAfterRecreate;
        private float singleDisplayedTime;
        @NotNull
        public static final CREATOR CREATOR = new CREATOR(null);

        public final int getProgressColor() {
            return this.progressColor;
        }

        public final void setProgressColor(int n) {
            this.progressColor = n;
        }

        public final int getLineColor() {
            return this.lineColor;
        }

        public final void setLineColor(int n) {
            this.lineColor = n;
        }

        public final float getProgressPadding() {
            return this.progressPadding;
        }

        public final void setProgressPadding(float f) {
            this.progressPadding = f;
        }

        public final float getProgressWidth() {
            return this.progressWidth;
        }

        public final void setProgressWidth(float f) {
            this.progressWidth = f;
        }

        public final float getSingleProgressWidth() {
            return this.singleProgressWidth;
        }

        public final void setSingleProgressWidth(float f) {
            this.singleProgressWidth = f;
        }

        public final float getAnimatedAbsoluteProgress() {
            return this.animatedAbsoluteProgress;
        }

        public final void setAnimatedAbsoluteProgress(float f) {
            this.animatedAbsoluteProgress = f;
        }

        public final float getCurrentAbsoluteProgress() {
            return this.currentAbsoluteProgress;
        }

        public final void setCurrentAbsoluteProgress(float f) {
            this.currentAbsoluteProgress = f;
        }

        public final int getCountProgress() {
            return this.countProgress;
        }

        public final void setCountProgress(int n) {
            this.countProgress = n;
        }

        public final int getProgressPercents() {
            return this.progressPercents;
        }

        public final void setProgressPercents(int n) {
            this.progressPercents = n;
        }

        public final int getDisplayedStepForListener() {
            return this.displayedStepForListener;
        }

        public final void setDisplayedStepForListener(int n) {
            this.displayedStepForListener = n;
        }

        public final boolean isProgressIsRunning() {
            return this.isProgressIsRunning;
        }

        public final void setProgressIsRunning(boolean bl) {
            this.isProgressIsRunning = bl;
        }

        public final boolean isNeedRestoreProgressAfterRecreate() {
            return this.isNeedRestoreProgressAfterRecreate;
        }

        public final void setNeedRestoreProgressAfterRecreate(boolean bl) {
            this.isNeedRestoreProgressAfterRecreate = bl;
        }

        public final float getSingleDisplayedTime() {
            return this.singleDisplayedTime;
        }

        public final void setSingleDisplayedTime(float f) {
            this.singleDisplayedTime = f;
        }

        public void writeToParcel(@NotNull Parcel out, int flags) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            super.writeToParcel(out, flags);
            out.writeInt(this.progressColor);
            out.writeInt(this.lineColor);
            out.writeInt(this.countProgress);
            out.writeInt(this.progressPercents);
            out.writeFloat(this.progressPadding);
            out.writeFloat(this.progressWidth);
            out.writeFloat(this.singleProgressWidth);
            out.writeFloat(this.currentAbsoluteProgress);
            out.writeFloat(this.animatedAbsoluteProgress);
            out.writeInt(this.isProgressIsRunning ? 1 : 0);
            out.writeInt(this.isNeedRestoreProgressAfterRecreate ? 1 : 0);
            out.writeInt(this.displayedStepForListener);
            out.writeFloat(this.singleDisplayedTime);
        }

        public int describeContents() {
            return 0;
        }

        public MultiProgressBarSavedState(@NotNull Parcelable superState) {
            Intrinsics.checkNotNullParameter((Object)superState, (String)"superState");
            super(superState);
            this.progressWidth = 10.0f;
            this.countProgress = 1;
            this.displayedStepForListener = -1;
            this.singleDisplayedTime = 1.0f;
        }

        private MultiProgressBarSavedState(Parcel in) {
            super(in);
            this.progressWidth = 10.0f;
            this.countProgress = 1;
            this.displayedStepForListener = -1;
            this.singleDisplayedTime = 1.0f;
            this.progressColor = in.readInt();
            this.lineColor = in.readInt();
            this.countProgress = in.readInt();
            this.progressPercents = in.readInt();
            this.progressPadding = in.readFloat();
            this.progressWidth = in.readFloat();
            this.singleProgressWidth = in.readFloat();
            this.currentAbsoluteProgress = in.readFloat();
            this.animatedAbsoluteProgress = in.readFloat();
            this.isProgressIsRunning = in.readInt() == 1;
            this.isNeedRestoreProgressAfterRecreate = in.readInt() == 1;
            this.displayedStepForListener = in.readInt();
            this.singleDisplayedTime = in.readFloat();
        }

        public /* synthetic */ MultiProgressBarSavedState(Parcel in, DefaultConstructorMarker $constructor_marker) {
            this(in);
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001d\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/genius/multiprogressbar/MultiProgressBar$MultiProgressBarSavedState$CREATOR;", "Landroid/os/Parcelable$Creator;", "Lcom/genius/multiprogressbar/MultiProgressBar$MultiProgressBarSavedState;", "()V", "createFromParcel", "parcel", "Landroid/os/Parcel;", "newArray", "", "size", "", "(I)[Lcom/genius/multiprogressbar/MultiProgressBar$MultiProgressBarSavedState;", "multiprogressbar_release"})
        public static final class CREATOR
        implements Parcelable.Creator<MultiProgressBarSavedState> {
            @NotNull
            public MultiProgressBarSavedState createFromParcel(@NotNull Parcel parcel) {
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                return new MultiProgressBarSavedState(parcel, null);
            }

            @NotNull
            public MultiProgressBarSavedState[] newArray(int size) {
                return new MultiProgressBarSavedState[size];
            }

            private CREATOR() {
            }

            public /* synthetic */ CREATOR(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/genius/multiprogressbar/MultiProgressBar$Companion;", "", "()V", "MIN_PADDING", "", "multiprogressbar_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

