/*
 * Decompiled with CFR 0.152.
 */
package io.github.georgwittberger.extendmdc.aspect;

import io.github.georgwittberger.extendmdc.annotation.ExtendMDC;
import io.github.georgwittberger.extendmdc.annotation.MDCValue;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.MDC;

@Aspect
public class ExtendMDCAspect {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(io.github.georgwittberger.extendmdc.annotation.ExtendMDC)")
    public Object extendMDC(ProceedingJoinPoint pjp) throws Throwable {
        Method method = ((MethodSignature)pjp.getSignature()).getMethod();
        ExtendMDC methodAnnotation = method.getAnnotation(ExtendMDC.class);
        try {
            this.addMethodDefinedValues(methodAnnotation);
            this.addParameterDefinedValues(method.getParameters(), pjp.getArgs());
            Object object = pjp.proceed();
            return object;
        }
        finally {
            this.removeMethodDefinedValues(methodAnnotation);
            this.removeParameterDefinedValues(method.getParameters());
        }
    }

    private void addMethodDefinedValues(ExtendMDC methodAnnotation) {
        for (MDCValue value : methodAnnotation.value()) {
            MDC.put((String)value.value(), (String)value.content());
        }
    }

    private void removeMethodDefinedValues(ExtendMDC methodAnnotation) {
        for (MDCValue value : methodAnnotation.value()) {
            MDC.remove((String)value.value());
        }
    }

    private void addParameterDefinedValues(Parameter[] parameters, Object[] args) {
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            MDCValue value = parameter.getAnnotation(MDCValue.class);
            if (value == null) continue;
            MDC.put((String)value.value(), (String)String.valueOf(args[i]));
        }
    }

    private void removeParameterDefinedValues(Parameter[] parameters) {
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            MDCValue value = parameter.getAnnotation(MDCValue.class);
            if (value == null) continue;
            MDC.remove((String)value.value());
        }
    }
}

