/*
 * Decompiled with CFR 0.152.
 */
package nguyen.gerald.echo;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpUtils;
import javax.servlet.http.Part;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/echo"})
public class EchoController {
    private static final Logger log = LoggerFactory.getLogger(EchoController.class);
    public static final String METHOD = "method";
    public static final String PATH = "path";
    public static final String PROTOCOL = "protocol";
    public static final String QUERY_STRING = "queryString";
    public static final String QUERY = "query";
    public static final String APPLICATION_X_WWW_FORM_URLENCODED = "application/x-www-form-urlencoded";
    public static final String BODY = "body";
    public static final String FORM = "form";
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";
    public static final String HEADERS = "headers";
    private final ObjectWriter objectWriter;

    public EchoController(ObjectMapper objectMapper) {
        this.objectWriter = objectMapper.writerWithDefaultPrettyPrinter();
    }

    @RequestMapping(value={""})
    public Map<String, Object> echo(HttpServletRequest request) throws IOException, ServletException {
        Map<String, Object> details = this.extractDetails(request);
        this.logRequestDetails(details);
        return details;
    }

    protected void logRequestDetails(Map<String, Object> details) throws JsonProcessingException {
        String detailsAsStr = this.objectWriter.writeValueAsString(details);
        log.info("Request details: {}", (Object)detailsAsStr);
    }

    protected Map<String, Object> extractDetails(HttpServletRequest request) throws IOException, ServletException {
        String contentType;
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>();
        details.put(METHOD, request.getMethod());
        details.put(PATH, request.getRequestURI());
        details.put(PROTOCOL, request.getProtocol());
        String queryString = request.getQueryString();
        if (queryString != null && !queryString.isBlank()) {
            details.put(QUERY_STRING, queryString);
            details.put(QUERY, this.extractQuery(queryString));
        }
        if ((contentType = request.getContentType()) != null) {
            if (contentType.equals(APPLICATION_X_WWW_FORM_URLENCODED)) {
                String formData = new String(request.getInputStream().readAllBytes());
                details.put(BODY, formData);
                details.put(FORM, this.extractQuery(formData));
            } else if (contentType.startsWith(MULTIPART_FORM_DATA)) {
                Collection parts = request.getParts();
                details.put(BODY, this.describeMultipartBody(parts));
                HashMap<String, Object> formData = new HashMap<String, Object>();
                for (Part part : parts) {
                    String name = part.getName();
                    String value = this.describePart(part);
                    if (formData.containsKey(name)) {
                        Object existingValue = formData.get(name);
                        if (existingValue instanceof String) {
                            formData.put(name, List.of(existingValue, value));
                            continue;
                        }
                        ArrayList<String> newList = new ArrayList<String>((List)existingValue);
                        newList.add(value);
                        formData.put(name, newList);
                        continue;
                    }
                    formData.put(name, value);
                }
                details.put(FORM, formData);
            }
        }
        details.put(HEADERS, this.extractHeaders(request));
        return details;
    }

    protected String describeMultipartBody(Collection<Part> parts) {
        return "<" + parts.size() + " parts>";
    }

    protected String describePart(Part part) throws IOException {
        byte[] bytes = part.getInputStream().readAllBytes();
        String contentType = part.getContentType();
        if (contentType == null) {
            return new String(bytes);
        }
        return String.format("<file: %s, size: %d bytes>", part.getSubmittedFileName(), bytes.length);
    }

    protected Map<String, Object> extractQuery(String queryString) {
        Hashtable queryMap = HttpUtils.parseQueryString((String)queryString);
        if (queryMap.isEmpty()) {
            return null;
        }
        HashMap<String, Object> details = new HashMap<String, Object>();
        for (Map.Entry e : queryMap.entrySet()) {
            String key = (String)e.getKey();
            String[] value = (String[])e.getValue();
            if (value.length == 1) {
                details.put(key, value[0]);
                continue;
            }
            details.put(key, value);
        }
        return details;
    }

    protected Map<String, Object> extractHeaders(HttpServletRequest request) {
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>();
        Enumeration headerNames = request.getHeaderNames();
        Iterator it = headerNames.asIterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            ArrayList values = Collections.list(request.getHeaders(name));
            if (values.size() == 1) {
                details.put(name, values.get(0));
                continue;
            }
            details.put(name, values);
        }
        return details;
    }
}

