/*
 * Decompiled with CFR 0.152.
 */
package giis.tdrules.client;

import giis.tdrules.client.TdRulesCache;
import giis.tdrules.client.TdRulesCacheManager;
import giis.tdrules.openapi.invoker.ApiClient;
import giis.tdrules.openapi.model.QueryEntitiesBody;
import giis.tdrules.openapi.model.QueryParametersBody;
import giis.tdrules.openapi.model.TdRules;
import giis.tdrules.openapi.model.TdRulesBody;
import giis.tdrules.openapi.model.TdSchema;
import giis.tdrules.openapi.model.VersionBody;

public class TdRulesApi
extends giis.tdrules.openapi.api.TdRulesApi {
    public static final String DEFAULT_ENDPOINT = "https://in2test.lsi.uniovi.es/tdrules/api/v4";
    private TdRulesCacheManager cacheMgr = new TdRulesCacheManager(super.getApiClient().getBasePath());

    public TdRulesApi(String endpoint) {
        super(new ApiClient().setBasePath("".equals(TdRulesApi.coalesce(endpoint)) ? DEFAULT_ENDPOINT : endpoint));
    }

    public TdRulesApi() {
        this("");
    }

    public TdRulesApi setCache(String location) {
        this.cacheMgr.setCache(location);
        return this;
    }

    public TdRules getRules(TdSchema schema, String query, String options) {
        TdRulesBody request = new TdRulesBody();
        request.setSchema(schema);
        request.setQuery(query);
        request.setOptions(TdRulesApi.coalesce(options));
        TdRulesCache cache = this.cacheMgr.getCache("rulesPost", request);
        if (this.cacheMgr.useCache() && cache.hit()) {
            return (TdRules)cache.getPayload(TdRules.class);
        }
        TdRules result = super.rulesPost(request);
        if (this.cacheMgr.useCache()) {
            cache.putPayload(result);
        }
        return result;
    }

    public TdRules getMutants(TdSchema schema, String query, String options) {
        TdRulesBody request = new TdRulesBody();
        request.setSchema(schema);
        request.setQuery(query);
        request.setOptions(TdRulesApi.coalesce(options));
        TdRulesCache cache = this.cacheMgr.getCache("mutantsPost", request);
        if (this.cacheMgr.useCache() && cache.hit()) {
            return (TdRules)cache.getPayload(TdRules.class);
        }
        TdRules result = super.mutantsPost(request);
        if (this.cacheMgr.useCache()) {
            cache.putPayload(result);
        }
        return result;
    }

    public QueryEntitiesBody getEntities(String sql) {
        return this.getEntities(sql, "");
    }

    public QueryEntitiesBody getEntities(String sql, String storetype) {
        TdRulesCache cache = this.cacheMgr.getCache("queryEntitiesPost", sql + "storetype=" + storetype);
        if (this.cacheMgr.useCache() && cache.hit()) {
            return (QueryEntitiesBody)cache.getPayload(QueryEntitiesBody.class);
        }
        QueryEntitiesBody result = super.queryEntitiesPost(storetype, sql);
        if (this.cacheMgr.useCache()) {
            cache.putPayload(result);
        }
        return result;
    }

    public QueryParametersBody getParameters(String sql) {
        return this.getParameters(sql, "");
    }

    public QueryParametersBody getParameters(String sql, String storetype) {
        TdRulesCache cache = this.cacheMgr.getCache("queryParametersPost", sql + "storetype=" + storetype);
        if (this.cacheMgr.useCache() && cache.hit()) {
            return (QueryParametersBody)cache.getPayload(QueryParametersBody.class);
        }
        QueryParametersBody result = super.queryParametersPost(storetype, sql);
        if (this.cacheMgr.useCache()) {
            cache.putPayload(result);
        }
        return result;
    }

    public VersionBody getVersion() {
        return super.versionGet();
    }

    private static String coalesce(String value) {
        return value == null ? "" : value.trim();
    }
}

