/*
 * Decompiled with CFR 0.152.
 */
package giis.tdrules.client;

import giis.portable.util.FileUtil;
import giis.portable.util.JavaCs;
import giis.tdrules.model.io.ModelJsonSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TdRulesCache {
    private static final Logger log = LoggerFactory.getLogger(TdRulesCache.class);
    private ModelJsonSerializer serializer = new ModelJsonSerializer();
    String endpoint;
    String payload;
    String hash;
    String cacheFile;
    String hit;

    public TdRulesCache(String cacheFolder, String endpoint, Object request) {
        this.endpoint = endpoint;
        this.payload = this.serializer.serialize(request, true);
        this.hash = JavaCs.getHash((String)this.payload);
        this.ensureCacheFolder(cacheFolder, endpoint);
        this.cacheFile = this.getCacheFile(cacheFolder, endpoint, this.hash);
        this.hit = FileUtil.fileRead((String)this.cacheFile, (boolean)false);
        log.debug("Cache {} {} hit: {}", new Object[]{endpoint, this.hash, this.hit != null});
    }

    public boolean hit() {
        return this.hit != null;
    }

    public Object getPayload(Class clazz) {
        return this.serializer.deserialize(this.hit, clazz);
    }

    public void putPayload(Object result) {
        FileUtil.fileWrite((String)this.cacheFile, (String)this.serializer.serialize(result, true));
        log.debug("Cache {} {} update.", (Object)this.endpoint, (Object)this.hash);
    }

    private void ensureCacheFolder(String cacheFolder, String endpoint) {
        FileUtil.createDirectory((String)FileUtil.getPath((String)cacheFolder, (String)endpoint));
    }

    private String getCacheFile(String cacheFolder, String endpoint, String hash) {
        return FileUtil.getPath((String)cacheFolder, (String)endpoint, (String)(hash + ".json"));
    }
}

