/*
 * Decompiled with CFR 0.152.
 */
package giis.tdrules.client;

import giis.portable.util.FileUtil;
import giis.tdrules.client.TdRulesApi;
import giis.tdrules.client.TdRulesCache;

public class TdRulesCacheManager {
    private boolean useCache = false;
    private String cacheLocation = "";
    private static String version = "";
    private String endpoint = "";

    public TdRulesCacheManager(String endpoint) {
        this.endpoint = endpoint;
    }

    public static void reset() {
        version = "";
    }

    public void setCache(String location) {
        boolean bl = this.useCache = !"".equals(this.coalesce(location));
        if (!this.useCache) {
            return;
        }
        if ("".equals(version)) {
            version = new TdRulesApi(this.endpoint).getVersion().getServiceVersion();
        }
        this.cacheLocation = this.useCache ? FileUtil.getPath((String)location, (String)version) : "";
    }

    public boolean useCache() {
        return this.useCache;
    }

    public TdRulesCache getCache(String endpoint, Object request) {
        return this.useCache() ? new TdRulesCache(this.cacheLocation, endpoint, request) : null;
    }

    private String coalesce(String value) {
        return value == null ? "" : value.trim();
    }
}

