/*
 * Decompiled with CFR 0.152.
 */
package giis.tdrules.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import giis.tdrules.model.shared.ModelUtil;
import giis.tdrules.openapi.model.Ddl;
import giis.tdrules.openapi.model.TdAttribute;
import giis.tdrules.openapi.model.TdEntity;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public interface ITdEntityExtension {
    public List<TdAttribute> getAttributes();

    public List<Ddl> getDdls();

    public String getEntitytype();

    public void setEntitytype(String var1);

    public Map<String, String> getExtended();

    @JsonIgnore
    default public List<TdAttribute> getRids() {
        ArrayList<TdAttribute> rids = new ArrayList<TdAttribute>();
        for (TdAttribute attribute : ModelUtil.safe(this.getAttributes())) {
            if ("".equals(attribute.getRid())) continue;
            rids.add(attribute);
        }
        return rids;
    }

    @JsonIgnore
    default public List<String> getUniqueRids() {
        LinkedHashSet<String> rids = new LinkedHashSet<String>();
        for (TdAttribute attribute : ModelUtil.safe(this.getAttributes())) {
            if ("".equals(attribute.getRid())) continue;
            rids.add(attribute.getRid());
        }
        return new ArrayList<String>(rids);
    }

    @JsonIgnore
    default public List<String> getUniqueRidNames() {
        LinkedHashSet<String> rids = new LinkedHashSet<String>();
        for (TdAttribute attribute : ModelUtil.safe(this.getAttributes())) {
            if ("".equals(attribute.getRidname())) continue;
            rids.add(attribute.getRidname());
        }
        return new ArrayList<String>(rids);
    }

    @JsonIgnore
    default public TdAttribute getUid() {
        for (TdAttribute attribute : ModelUtil.safe(this.getAttributes())) {
            if (!attribute.isUid()) continue;
            return attribute;
        }
        return null;
    }

    @JsonIgnore
    default public TdAttribute getAttribute(String name) {
        for (TdAttribute attribute : ModelUtil.safe(this.getAttributes())) {
            if (!attribute.getName().equalsIgnoreCase(name)) continue;
            return attribute;
        }
        return null;
    }

    @JsonIgnore
    default public Ddl getDdl(String operation) {
        for (Ddl ddl : ModelUtil.safe(this.getDdls())) {
            if (!ddl.getCommand().equalsIgnoreCase(operation.trim())) continue;
            return ddl;
        }
        return null;
    }

    @JsonIgnore
    default public String getExtendedItem(String key) {
        Map<String, String> extended = this.getExtended();
        return extended == null ? null : extended.get(key);
    }

    @JsonIgnore
    default public boolean isObject() {
        return "table".equalsIgnoreCase(this.getEntitytype());
    }

    @JsonIgnore
    default public boolean isType() {
        return "type".equalsIgnoreCase(this.getEntitytype());
    }

    @JsonIgnore
    default public boolean isArray() {
        return "array".equalsIgnoreCase(this.getEntitytype());
    }

    @JsonIgnore
    default public TdEntity setObject() {
        this.setEntitytype("table");
        return (TdEntity)this;
    }

    @JsonIgnore
    default public TdEntity setType() {
        this.setEntitytype("type");
        return (TdEntity)this;
    }

    @JsonIgnore
    default public TdEntity setArray() {
        this.setEntitytype("array");
        return (TdEntity)this;
    }
}

