/*
 * Decompiled with CFR 0.152.
 */
package giis.tdrules.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import giis.tdrules.model.shared.ModelException;
import giis.tdrules.model.shared.ModelUtil;
import giis.tdrules.openapi.model.TdEntity;
import giis.tdrules.openapi.model.TdSchema;
import java.util.ArrayList;
import java.util.List;

public interface ITdSchemaExtension {
    public TdSchema addEntitiesItem(TdEntity var1);

    public List<TdEntity> getEntities();

    @JsonIgnore
    default public ITdSchemaExtension addEntitiesItemIfNotExist(TdEntity entity) {
        TdEntity existingEntity = this.getEntityOrNull(entity.getName());
        if (existingEntity == null) {
            this.addEntitiesItem(entity);
        }
        return this;
    }

    @JsonIgnore
    default public List<String> getEntityNames() {
        return this.getEntityNames(true, true, true);
    }

    @JsonIgnore
    default public List<String> getEntityNames(boolean includeTables, boolean includeViews, boolean includeTypes) {
        ArrayList<String> names = new ArrayList<String>();
        for (TdEntity entity : ModelUtil.safe(this.getEntities())) {
            if (!(includeTables && "table".equals(entity.getEntitytype()) || includeTables && "array".equals(entity.getEntitytype()) || includeViews && "view".equals(entity.getEntitytype())) && (!includeTypes || !"type".equals(entity.getEntitytype()))) continue;
            names.add(entity.getName());
        }
        return names;
    }

    @JsonIgnore
    default public TdEntity getEntity(String name) {
        TdEntity entity = this.getEntityOrNull(name);
        if (entity == null) {
            throw new ModelException("Can't find any entity in the schema with name " + name);
        }
        return entity;
    }

    @JsonIgnore
    default public TdEntity getEntityOrNull(String name) {
        for (TdEntity entity : ModelUtil.safe(this.getEntities())) {
            if (!entity.getName().equalsIgnoreCase(name.trim())) continue;
            return entity;
        }
        return null;
    }
}

