/*
 * Decompiled with CFR 0.152.
 */
package giis.tdrules.model.io;

import giis.portable.xml.tiny.XNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class BaseXmlSerializer {
    protected String setAttribute(String key, String value) {
        if (value == null || value.equals("")) {
            return "";
        }
        return " " + key + "=\"" + XNode.encodeAttribute((String)value) + "\"";
    }

    protected String setAttribute(String key, boolean value) {
        return this.setAttribute(key, value ? "true" : "false");
    }

    protected String setElemAttribute(int indentation, String key, String value) {
        if (value == null || value.equals("")) {
            return "";
        }
        String indent = indentation < 0 ? "" : "\n";
        indent = indent + (indentation <= 0 ? "" : new String(new char[indentation]).replace("\u0000", " "));
        return indent + "<" + key + ">" + XNode.encodeText((String)value) + "</" + key + ">";
    }

    protected String setElemAttribute(String key, String value) {
        return this.setElemAttribute(-1, key, value);
    }

    protected String setExtendedAttributes(Map<String, String> extended) {
        if (extended == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String key : extended.keySet()) {
            sb.append(this.setAttribute(key, extended.get(key)));
        }
        return sb.toString();
    }

    protected String getElemAttribute(XNode root, String key) {
        XNode elem = root.getChild(key);
        return elem == null ? "" : elem.innerText();
    }

    protected List<String> getExtendedAttributeNames(XNode root, String[] nativeAttributes) {
        ArrayList<String> ret = new ArrayList<String>();
        if (root == null) {
            return ret;
        }
        List allList = root.getAttributeNames();
        if (nativeAttributes.length == 0) {
            return allList;
        }
        for (String item : allList) {
            if (this.arrayContainsString(nativeAttributes, item)) continue;
            ret.add(item);
        }
        return ret;
    }

    private boolean arrayContainsString(String[] searchIn, String searchValue) {
        for (String item : searchIn) {
            if (!item.equals(searchValue)) continue;
            return true;
        }
        return false;
    }
}

