/*
 * Decompiled with CFR 0.152.
 */
package giis.tdrules.model.io;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import giis.tdrules.model.shared.ModelException;

public class ModelJsonSerializer {
    public String serialize(Object model, boolean prettyPrint) {
        ObjectMapper mapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL).setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        try {
            return prettyPrint ? mapper.writerWithDefaultPrettyPrinter().writeValueAsString(model) : mapper.writeValueAsString(model);
        }
        catch (JsonProcessingException e) {
            throw new ModelException("Exception serializing json", (Exception)((Object)e));
        }
    }

    public Object deserialize(String json, Class<?> clazz) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.readValue(json, clazz);
        }
        catch (JsonProcessingException e) {
            throw new ModelException("Exception deserializing object", (Exception)((Object)e));
        }
    }
}

