/*
 * Decompiled with CFR 0.152.
 */
package giis.tdrules.model.io;

import giis.portable.xml.tiny.XNode;
import giis.tdrules.model.io.BaseXmlSerializer;
import giis.tdrules.model.io.TdSchemaXmlSerializer;
import giis.tdrules.model.shared.ModelUtil;
import giis.tdrules.model.shared.RuleTypes;
import giis.tdrules.openapi.model.QueryEntitiesBody;
import giis.tdrules.openapi.model.QueryParam;
import giis.tdrules.openapi.model.QueryParametersBody;
import giis.tdrules.openapi.model.TdRule;
import giis.tdrules.openapi.model.TdRules;
import giis.tdrules.openapi.model.TdRulesBody;

public class TdRulesXmlSerializer
extends BaseXmlSerializer {
    private static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final String VERSION = "version";
    private static final String DEVELOPMENT = "development";
    private static final String PARSEDSQL = "parsedsql";
    private static final String ERROR = "error";

    public TdRules deserialize(String xml) {
        XNode xtdrules = new XNode(xml);
        TdRules tdrules = new TdRules();
        String rulesClass = RuleTypes.normalizeV4(xtdrules.name());
        tdrules.setRulesClass(rulesClass);
        tdrules.setVersion(this.getElemAttribute(xtdrules, VERSION));
        if (xtdrules.getChild(VERSION) != null) {
            tdrules.setEnvironment(xtdrules.getChild(VERSION).getChild(DEVELOPMENT) == null ? "" : DEVELOPMENT);
        }
        for (String attr : this.getExtendedAttributeNames(xtdrules, new String[0])) {
            tdrules.putSummaryItem(attr, xtdrules.getAttribute(attr));
        }
        tdrules.setQuery(this.getElemAttribute(xtdrules, "sql"));
        tdrules.setParsedquery(this.getElemAttribute(xtdrules, PARSEDSQL));
        tdrules.setError(this.getElemAttribute(xtdrules, ERROR));
        String ruleTag = this.rulesClassToRuleTag(rulesClass);
        XNode xrules = xtdrules.getChild(ruleTag + "s");
        if (xrules == null) {
            return tdrules;
        }
        for (XNode rnode : xrules.getChildren(ruleTag)) {
            TdRule rule = new TdRule();
            for (String attr : this.getExtendedAttributeNames(rnode, new String[0])) {
                rule.putSummaryItem(attr, rnode.getAttribute(attr));
            }
            rule.setId(this.getElemAttribute(rnode, "id"));
            rule.setCategory(this.getElemAttribute(rnode, "category"));
            rule.setMaintype(this.getElemAttribute(rnode, "type"));
            rule.setSubtype(this.getElemAttribute(rnode, "subtype"));
            rule.setLocation(this.getElemAttribute(rnode, "location"));
            rule.setEquivalent(rnode.getChild("equivalent") == null ? "" : "true");
            rule.setQuery(this.getElemAttribute(rnode, "sql"));
            rule.setDescription(this.getElemAttribute(rnode, "description"));
            rule.setError(this.getElemAttribute(rnode, ERROR));
            tdrules.addRulesItem(rule);
        }
        return tdrules;
    }

    private String rulesClassToRuleTag(String rulesClass) {
        return "fpc".equals(RuleTypes.normalizeV4(rulesClass)) ? "fpcrule" : "mutant";
    }

    public String serialize(TdRules sqr) {
        StringBuilder sb = new StringBuilder();
        String rulesClass = sqr.getRulesClass();
        sb.append(XML_HEADER).append("\n<" + RuleTypes.normalizeV3(rulesClass)).append(this.setExtendedAttributes(sqr.getSummary())).append(">");
        sb.append("\n<version>").append(sqr.getVersion()).append(DEVELOPMENT.equals(sqr.getEnvironment()) ? "<development/>" : "").append("</version>");
        sb.append(this.setElemAttribute(0, "sql", sqr.getQuery())).append(this.setElemAttribute(0, PARSEDSQL, sqr.getParsedquery()));
        sb.append(this.setElemAttribute(0, ERROR, sqr.getError()));
        String ruleTag = this.rulesClassToRuleTag(rulesClass);
        if ("".equals(sqr.getError())) {
            sb.append("\n<" + ruleTag + "s>");
            for (TdRule rule : ModelUtil.safe(sqr.getRules())) {
                sb.append("\n").append(this.serialize(rule, ruleTag));
            }
            sb.append("\n</" + ruleTag + "s>");
        }
        sb.append("\n</" + RuleTypes.normalizeV3(rulesClass) + ">");
        return sb.toString();
    }

    public String serialize(TdRule rule, String ruleTag) {
        StringBuilder sb = new StringBuilder();
        sb.append("  <" + ruleTag).append(this.setExtendedAttributes(rule.getSummary())).append(">");
        sb.append(this.setElemAttribute("id", rule.getId())).append(this.setElemAttribute("category", rule.getCategory())).append(this.setElemAttribute("type", rule.getMaintype())).append(this.setElemAttribute("subtype", rule.getSubtype())).append(this.setElemAttribute("location", rule.getLocation())).append("true".equals(rule.getEquivalent()) ? "\n    <equivalent/>" : "").append(this.setElemAttribute(4, "sql", rule.getQuery())).append(this.setElemAttribute(4, "description", rule.getDescription())).append(this.setElemAttribute(4, ERROR, rule.getError())).append("\n  </" + ruleTag + ">");
        return sb.toString();
    }

    public QueryEntitiesBody deserializeEntities(String xml) {
        XNode xentities = new XNode(xml);
        QueryEntitiesBody entities = new QueryEntitiesBody();
        entities.setError(this.getElemAttribute(xentities, ERROR));
        for (XNode xentity : xentities.getChildren("table")) {
            entities.addEntitiesItem(XNode.decodeText((String)xentity.innerText()));
        }
        return entities;
    }

    public QueryParametersBody deserializeParameters(String xml) {
        XNode xparams = new XNode(xml);
        QueryParametersBody sparams = new QueryParametersBody();
        sparams.setError(this.getElemAttribute(xparams, ERROR));
        XNode paramNode = xparams.getChild("parameters");
        if (paramNode == null) {
            return sparams;
        }
        for (XNode xparam : paramNode.getChildren("parameter")) {
            QueryParam param = new QueryParam();
            param.setName(xparam.getAttribute("name"));
            param.setValue(xparam.getAttribute("value"));
            sparams.addParametersItem(param);
        }
        return sparams;
    }

    public String serialize(QueryEntitiesBody model) {
        StringBuilder sb = new StringBuilder();
        sb.append(XML_HEADER).append("\n<sqltables>");
        if ("".equals(model.getError())) {
            for (String entity : ModelUtil.safe(model.getEntities())) {
                sb.append(this.setElemAttribute(0, "table", entity));
            }
        } else {
            sb.append(this.setElemAttribute(0, ERROR, model.getError()));
        }
        sb.append("\n</sqltables>");
        return sb.toString();
    }

    public String serialize(QueryParametersBody model) {
        StringBuilder sb = new StringBuilder();
        sb.append(XML_HEADER).append("\n<sqlparameters>");
        if ("".equals(model.getError())) {
            sb.append("\n<parameters>");
            for (QueryParam param : ModelUtil.safe(model.getParameters())) {
                sb.append("\n<parameter").append(this.setAttribute("name", param.getName())).append(this.setAttribute("value", param.getValue())).append(" />");
            }
            sb.append("\n</parameters>").append(this.setElemAttribute(0, PARSEDSQL, model.getParsedquery()));
        } else {
            sb.append(this.setElemAttribute(0, ERROR, model.getError()));
        }
        sb.append("\n</sqlparameters>");
        return sb.toString();
    }

    public String serialize(TdRulesBody sqb) {
        StringBuilder sb = new StringBuilder();
        sb.append("<body>");
        sb.append(this.setElemAttribute(0, "sql", sqb.getQuery()));
        if (sqb.getSchema() != null) {
            sb.append("\n").append(new TdSchemaXmlSerializer().serialize(sqb.getSchema()));
        }
        sb.append(this.setElemAttribute(0, "options", sqb.getOptions()));
        sb.append("\n</body>");
        return sb.toString();
    }
}

