/*
 * Decompiled with CFR 0.152.
 */
package giis.tdrules.model.io;

import giis.portable.xml.tiny.XNode;
import giis.tdrules.model.io.BaseXmlSerializer;
import giis.tdrules.model.shared.ModelUtil;
import giis.tdrules.openapi.model.Ddl;
import giis.tdrules.openapi.model.TdAttribute;
import giis.tdrules.openapi.model.TdCheck;
import giis.tdrules.openapi.model.TdEntity;
import giis.tdrules.openapi.model.TdSchema;

public class TdSchemaXmlSerializer
extends BaseXmlSerializer {
    private static final String DBMS = "dbms";
    private static final String ENTITY_NODE = "table";
    private static final String ATTRIBUTE_NODE = "column";
    private static final String NAME = "name";
    private static final String ENTITY_TYPE = "type";
    private static final String DATA_TYPE = "type";
    private static final String COMPOSITETYPE = "compositetype";
    private static final String SUBTYPE = "subtype";
    private static final String SIZE = "size";
    private static final String UID = "key";
    private static final String AUTOINCREMENT = "autoincrement";
    private static final String NOTNULL = "notnull";
    private static final String READONLY = "readonly";
    private static final String RID = "fk";
    private static final String RID_NAME = "fkname";
    private static final String CHECKIN = "checkin";
    private static final String DEFAULT = "default";
    private static final String CHECK_CONSTRAINT = "check";
    private static final String DDL_COMMAND_NODE = "command";
    private static final String DDL = "ddl";

    public TdSchema deserialize(String xml) {
        XNode xschema = new XNode(xml);
        TdSchema schema = new TdSchema();
        this.deserializeSchemaAttributes(xschema, schema);
        for (XNode tnode : xschema.getChildren(ENTITY_NODE)) {
            TdEntity entity = new TdEntity();
            this.deserializeEntityAttributes(tnode, entity);
            this.deserializeEntities(tnode, entity);
            this.deserializeChecks(tnode, entity);
            this.deserializeDdls(tnode, entity);
            schema.addEntitiesItem(entity);
        }
        return schema;
    }

    private void deserializeSchemaAttributes(XNode xschema, TdSchema schema) {
        schema.setStoretype(xschema.getAttribute(DBMS));
        schema.setCatalog(xschema.getAttribute("catalog"));
        schema.setSchema(xschema.getAttribute("schema"));
    }

    private void deserializeEntityAttributes(XNode tnode, TdEntity entity) {
        entity.setName(tnode.getAttribute(NAME));
        entity.setEntitytype(tnode.getAttribute("type"));
        entity.setSubtype(tnode.getAttribute(SUBTYPE));
        for (String attr : this.getExtendedAttributeNames(tnode, new String[]{NAME, "type", SUBTYPE})) {
            entity.putExtendedItem(attr, tnode.getAttribute(attr));
        }
    }

    private void deserializeEntities(XNode tnode, TdEntity entity) {
        for (XNode cnode : tnode.getChildren(ATTRIBUTE_NODE)) {
            TdAttribute attribute = new TdAttribute();
            this.deserializeAttributeDescriptors(cnode, attribute);
            entity.addAttributesItem(attribute);
        }
    }

    private void deserializeAttributeDescriptors(XNode cnode, TdAttribute attribute) {
        attribute.setName(cnode.getAttribute(NAME));
        attribute.setDatatype(cnode.getAttribute("type"));
        attribute.setCompositetype(cnode.getAttribute(COMPOSITETYPE));
        attribute.setSubtype(cnode.getAttribute(SUBTYPE));
        attribute.setSize(cnode.getAttribute(SIZE));
        attribute.setUid(cnode.getAttribute(UID));
        attribute.setAutoincrement(cnode.getAttribute(AUTOINCREMENT));
        attribute.setNotnull(cnode.getAttribute(NOTNULL));
        attribute.setReadonly(cnode.getAttribute(READONLY));
        attribute.setRid(cnode.getAttribute(RID));
        attribute.setRidname(cnode.getAttribute(RID_NAME));
        attribute.setCheckin(cnode.getAttribute(CHECKIN));
        attribute.setDefaultvalue(cnode.getAttribute(DEFAULT));
        for (String attr : this.getExtendedAttributeNames(cnode, new String[]{NAME, "type", COMPOSITETYPE, SUBTYPE, SIZE, UID, AUTOINCREMENT, NOTNULL, READONLY, RID, RID_NAME, CHECKIN, DEFAULT})) {
            attribute.putExtendedItem(attr, cnode.getAttribute(attr));
        }
    }

    private void deserializeChecks(XNode tnode, TdEntity entity) {
        for (XNode cnode : tnode.getChildren(CHECK_CONSTRAINT)) {
            TdCheck check = new TdCheck();
            check.setAttribute(cnode.getAttribute(ATTRIBUTE_NODE));
            check.setName(cnode.getAttribute(NAME));
            check.setConstraint(XNode.decodeText((String)cnode.innerText()));
            entity.addChecksItem(check);
        }
    }

    private void deserializeDdls(XNode tnode, TdEntity entity) {
        for (XNode cnode : tnode.getChildren(DDL)) {
            Ddl ddl = new Ddl();
            ddl.setCommand(cnode.getAttribute(DDL_COMMAND_NODE));
            ddl.setQuery(XNode.decodeText((String)cnode.innerText()));
            entity.addDdlsItem(ddl);
        }
    }

    public String serialize(TdSchema sch) {
        StringBuilder sb = new StringBuilder();
        sb.append("<schema").append(this.setAttribute(DBMS, sch.getStoretype())).append(this.setAttribute("catalog", sch.getCatalog())).append(this.setAttribute("schema", sch.getSchema())).append(">");
        for (TdEntity entity : ModelUtil.safe(sch.getEntities())) {
            this.appendEntity(sb, entity);
        }
        sb.append("\n</schema>");
        return sb.toString();
    }

    protected void appendEntity(StringBuilder sb, TdEntity entity) {
        sb.append("\n<table").append(this.setAttribute(NAME, entity.getName())).append(this.setAttribute("type", entity.getEntitytype())).append(this.setAttribute(SUBTYPE, entity.getSubtype())).append(this.setExtendedAttributes(entity.getExtended())).append(">");
        for (TdAttribute attribute : ModelUtil.safe(entity.getAttributes())) {
            this.appendAttribute(sb, attribute);
        }
        for (TdCheck check : ModelUtil.safe(entity.getChecks())) {
            sb.append("\n<check").append(this.setAttribute(ATTRIBUTE_NODE, check.getAttribute())).append(">").append(XNode.encodeText((String)check.getConstraint())).append("</check>");
        }
        for (Ddl ddl : ModelUtil.safe(entity.getDdls())) {
            sb.append("\n<ddl").append(this.setAttribute(DDL_COMMAND_NODE, ddl.getCommand())).append(">").append(XNode.encodeText((String)ddl.getQuery())).append("</ddl>");
        }
        sb.append("\n</table>");
    }

    protected void appendAttribute(StringBuilder sb, TdAttribute attribute) {
        sb.append("\n<column").append(this.setAttribute(NAME, attribute.getName())).append(this.setAttribute("type", attribute.getDatatype())).append(this.setAttribute(COMPOSITETYPE, attribute.getCompositetype())).append(this.setAttribute(SUBTYPE, attribute.getSubtype())).append(this.setAttribute(SIZE, attribute.getSize())).append(this.setAttribute(UID, attribute.getUid())).append(this.setAttribute(AUTOINCREMENT, attribute.getAutoincrement())).append(this.setAttribute(NOTNULL, attribute.getNotnull())).append(this.setAttribute(READONLY, attribute.getReadonly())).append(this.setAttribute(RID, attribute.getRid())).append(this.setAttribute(RID_NAME, attribute.getRidname())).append(this.setAttribute(CHECKIN, attribute.getCheckin())).append(this.setAttribute(DEFAULT, attribute.getDefaultvalue())).append(this.setExtendedAttributes(attribute.getExtended())).append(" />");
    }
}

