/*
 * Decompiled with CFR 0.152.
 */
package giis.tdrules.model.transform;

import giis.tdrules.model.shared.ModelException;
import giis.tdrules.model.shared.ModelUtil;
import giis.tdrules.openapi.model.TdAttribute;
import giis.tdrules.openapi.model.TdEntity;
import giis.tdrules.openapi.model.TdSchema;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaSorter {
    private static final Logger log = LoggerFactory.getLogger(SchemaSorter.class);
    private TdSchema schema;
    private List<String> excludeRidnames = new ArrayList<String>();
    private List<String[]> excludeRids = new ArrayList<String[]>();
    private boolean arrayHoist = false;

    public SchemaSorter(TdSchema schema) {
        this.schema = schema;
    }

    public SchemaSorter noFollowRidname(String constraintName) {
        this.excludeRidnames.add(constraintName.toLowerCase());
        return this;
    }

    public SchemaSorter noFollowRid(String fromEntity, String toEntity) {
        this.excludeRids.add(new String[]{fromEntity, toEntity});
        return this;
    }

    public SchemaSorter setArrayHoist() {
        this.arrayHoist = true;
        return this;
    }

    protected TdEntity getEntity(String entityName) {
        return this.schema.getEntity(entityName);
    }

    public List<String> sort(List<String> entityNames) {
        log.debug("*** Begin sort entities: {}", entityNames);
        int maxLevel = entityNames.size() * 2;
        ArrayList<String> orderedEntities = new ArrayList<String>();
        for (int i = 0; i < entityNames.size(); ++i) {
            log.trace("Sorting entity: {}", (Object)entityNames.get(i));
            String name = entityNames.get(i);
            this.getEntityAndDependentInOrder(1, maxLevel, name, orderedEntities, entityNames);
        }
        log.debug("      End sort entities: {}", orderedEntities);
        return orderedEntities;
    }

    private void getEntityAndDependentInOrder(int level, int maxLevel, String entityName, List<String> orderedEntities, List<String> originalEntities) {
        int i;
        log.trace("{} target: {} current entity list: {}", new Object[]{level, entityName, orderedEntities});
        if (level > maxLevel) {
            log.error("Too many recursive levels, the most probable reason is that schema has circular references");
            throw new ModelException("Too many recusive levels when trying sort entities");
        }
        TdEntity currentEntity = this.getEntity(entityName);
        List<TdAttribute> attributes = ModelUtil.safe(currentEntity.getAttributes());
        ArrayList<String> dependentEntities = new ArrayList<String>();
        for (i = 0; i < attributes.size(); ++i) {
            String dependency = this.getDependency(entityName, attributes.get(i), originalEntities);
            if (dependency == null) continue;
            dependentEntities.add(dependency);
        }
        for (i = 0; i < dependentEntities.size(); ++i) {
            this.getEntityAndDependentInOrder(level + 1, maxLevel, (String)dependentEntities.get(i), orderedEntities, originalEntities);
        }
        if (!this.containsIgnoreCase(orderedEntities, currentEntity.getName())) {
            orderedEntities.add(currentEntity.getName());
        }
        log.trace("{} target: {}   final entity list: {}", new Object[]{level, entityName, orderedEntities});
    }

    private String getDependency(String entityName, TdAttribute attribute, List<String> originalEntities) {
        boolean dependentByRid;
        boolean bl = dependentByRid = attribute.isRid() && !attribute.getRidEntity().equals(entityName) && this.attributeReferencesAnyOf(entityName, attribute, originalEntities) && !this.excludedRelation(entityName, attribute);
        if (dependentByRid) {
            return attribute.getRidEntity();
        }
        if ("type".equals(attribute.getCompositetype())) {
            return attribute.getDatatype();
        }
        if (this.arrayHoist && "array".equals(attribute.getCompositetype())) {
            return attribute.getDatatype();
        }
        return null;
    }

    private boolean excludedRelation(String entityName, TdAttribute attribute) {
        if (this.excludeRidnames.contains(attribute.getRidname().toLowerCase())) {
            return true;
        }
        for (String[] rid : this.excludeRids) {
            if (!rid[0].equalsIgnoreCase(entityName) || !rid[1].equalsIgnoreCase(attribute.getRidEntity())) continue;
            return true;
        }
        return false;
    }

    private boolean attributeReferencesAnyOf(String entityName, TdAttribute attribute, List<String> entities) {
        String refName = attribute.getRidEntity();
        boolean references = this.containsIgnoreCase(entities, refName);
        if (!references || !this.arrayHoist) {
            return references;
        }
        TdEntity refEntity = this.getEntity(refName);
        for (TdAttribute attr : refEntity.getAttributes()) {
            if (!"array".equals(attr.getCompositetype()) || !entityName.equals(attr.getDatatype())) continue;
            return false;
        }
        return references;
    }

    public List<String> getWithDependent(List<String> entities) {
        log.debug("*** Begin entity dependencies: {}", entities);
        for (int pos = 0; pos < entities.size(); ++pos) {
            log.trace("Get dependendencies of entity at postion: {}", (Object)pos);
            TdEntity entity = this.getEntity(entities.get(pos));
            log.trace("  Found entity: {}", (Object)entity.getName());
            List<TdAttribute> attributes = entity.getRids();
            for (int i = 0; i < attributes.size(); ++i) {
                TdAttribute attribute = attributes.get(i);
                log.trace("  Found dependency, atribute: {} - rid: {}", (Object)attribute.getName(), (Object)attribute.getRid());
                String dependentEntity = attribute.getRidEntity();
                if (this.containsIgnoreCase(entities, dependentEntity)) continue;
                entities.add(dependentEntity);
            }
        }
        log.debug("  End entity dependencies: {}", entities);
        return entities;
    }

    private boolean containsIgnoreCase(List<String> values, String target) {
        for (int j = 0; j < values.size(); ++j) {
            if (!values.get(j).equalsIgnoreCase(target)) continue;
            return true;
        }
        return false;
    }
}

