/*
 * Decompiled with CFR 0.152.
 */
package giis.tdrules.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"query", "error", "entities"})
public class QueryEntitiesBody {
    public static final String JSON_PROPERTY_QUERY = "query";
    @Nullable
    private String query = "";
    public static final String JSON_PROPERTY_ERROR = "error";
    @Nullable
    private String error = "";
    public static final String JSON_PROPERTY_ENTITIES = "entities";
    @Nullable
    private List<String> entities = new ArrayList<String>();

    public QueryEntitiesBody query(@Nullable String query) {
        this.query = query;
        return this;
    }

    @Nullable
    @JsonProperty(value="query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getQuery() {
        return this.query;
    }

    @JsonProperty(value="query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setQuery(@Nullable String query) {
        this.query = query;
    }

    public QueryEntitiesBody error(@Nullable String error) {
        this.error = error;
        return this;
    }

    @Nullable
    @JsonProperty(value="error")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getError() {
        return this.error;
    }

    @JsonProperty(value="error")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setError(@Nullable String error) {
        this.error = error;
    }

    public QueryEntitiesBody entities(@Nullable List<String> entities) {
        this.entities = entities;
        return this;
    }

    public QueryEntitiesBody addEntitiesItem(String entitiesItem) {
        if (this.entities == null) {
            this.entities = new ArrayList<String>();
        }
        this.entities.add(entitiesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="entities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getEntities() {
        return this.entities;
    }

    @JsonProperty(value="entities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEntities(@Nullable List<String> entities) {
        this.entities = entities;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryEntitiesBody queryEntitiesBody = (QueryEntitiesBody)o;
        return Objects.equals(this.query, queryEntitiesBody.query) && Objects.equals(this.error, queryEntitiesBody.error) && Objects.equals(this.entities, queryEntitiesBody.entities);
    }

    public int hashCode() {
        return Objects.hash(this.query, this.error, this.entities);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class QueryEntitiesBody {\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("    entities: ").append(this.toIndentedString(this.entities)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getQuery() != null) {
            try {
                joiner.add(String.format("%squery%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getQuery()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getError() != null) {
            try {
                joiner.add(String.format("%serror%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getError()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getEntities() != null) {
            for (int i = 0; i < this.getEntities().size(); ++i) {
                try {
                    joiner.add(String.format("%sentities%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getEntities().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return joiner.toString();
    }
}

