/*
 * Decompiled with CFR 0.152.
 */
package giis.tdrules.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import giis.tdrules.openapi.model.QueryParam;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"query", "parsedquery", "error", "parameters"})
public class QueryParametersBody {
    public static final String JSON_PROPERTY_QUERY = "query";
    @Nullable
    private String query = "";
    public static final String JSON_PROPERTY_PARSEDQUERY = "parsedquery";
    @Nullable
    private String parsedquery = "";
    public static final String JSON_PROPERTY_ERROR = "error";
    @Nullable
    private String error = "";
    public static final String JSON_PROPERTY_PARAMETERS = "parameters";
    @Nullable
    private List<QueryParam> parameters = new ArrayList<QueryParam>();

    public QueryParametersBody query(@Nullable String query) {
        this.query = query;
        return this;
    }

    @Nullable
    @JsonProperty(value="query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getQuery() {
        return this.query;
    }

    @JsonProperty(value="query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setQuery(@Nullable String query) {
        this.query = query;
    }

    public QueryParametersBody parsedquery(@Nullable String parsedquery) {
        this.parsedquery = parsedquery;
        return this;
    }

    @Nullable
    @JsonProperty(value="parsedquery")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getParsedquery() {
        return this.parsedquery;
    }

    @JsonProperty(value="parsedquery")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setParsedquery(@Nullable String parsedquery) {
        this.parsedquery = parsedquery;
    }

    public QueryParametersBody error(@Nullable String error) {
        this.error = error;
        return this;
    }

    @Nullable
    @JsonProperty(value="error")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getError() {
        return this.error;
    }

    @JsonProperty(value="error")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setError(@Nullable String error) {
        this.error = error;
    }

    public QueryParametersBody parameters(@Nullable List<QueryParam> parameters) {
        this.parameters = parameters;
        return this;
    }

    public QueryParametersBody addParametersItem(QueryParam parametersItem) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<QueryParam>();
        }
        this.parameters.add(parametersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="parameters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<QueryParam> getParameters() {
        return this.parameters;
    }

    @JsonProperty(value="parameters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setParameters(@Nullable List<QueryParam> parameters) {
        this.parameters = parameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryParametersBody queryParametersBody = (QueryParametersBody)o;
        return Objects.equals(this.query, queryParametersBody.query) && Objects.equals(this.parsedquery, queryParametersBody.parsedquery) && Objects.equals(this.error, queryParametersBody.error) && Objects.equals(this.parameters, queryParametersBody.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.query, this.parsedquery, this.error, this.parameters);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class QueryParametersBody {\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    parsedquery: ").append(this.toIndentedString(this.parsedquery)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("    parameters: ").append(this.toIndentedString(this.parameters)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getQuery() != null) {
            try {
                joiner.add(String.format("%squery%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getQuery()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getParsedquery() != null) {
            try {
                joiner.add(String.format("%sparsedquery%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getParsedquery()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getError() != null) {
            try {
                joiner.add(String.format("%serror%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getError()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getParameters() != null) {
            for (int i = 0; i < this.getParameters().size(); ++i) {
                if (this.getParameters().get(i) == null) continue;
                joiner.add(this.getParameters().get(i).toUrlQueryString(String.format("%sparameters%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        return joiner.toString();
    }
}

