/*
 * Decompiled with CFR 0.152.
 */
package giis.tdrules.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import giis.tdrules.model.ITdEntityExtension;
import giis.tdrules.openapi.model.Ddl;
import giis.tdrules.openapi.model.TdAttribute;
import giis.tdrules.openapi.model.TdCheck;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"name", "entitytype", "subtype", "extended", "attributes", "checks", "ddls"})
public class TdEntity
implements ITdEntityExtension {
    public static final String JSON_PROPERTY_NAME = "name";
    @Nullable
    private String name = "";
    public static final String JSON_PROPERTY_ENTITYTYPE = "entitytype";
    @Nullable
    private String entitytype = "";
    public static final String JSON_PROPERTY_SUBTYPE = "subtype";
    @Nullable
    private String subtype = "";
    public static final String JSON_PROPERTY_EXTENDED = "extended";
    @Nullable
    private Map<String, String> extended = new LinkedHashMap<String, String>();
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    @Nullable
    private List<TdAttribute> attributes = new ArrayList<TdAttribute>();
    public static final String JSON_PROPERTY_CHECKS = "checks";
    @Nullable
    private List<TdCheck> checks = new ArrayList<TdCheck>();
    public static final String JSON_PROPERTY_DDLS = "ddls";
    @Nullable
    private List<Ddl> ddls = new ArrayList<Ddl>();

    public TdEntity name(@Nullable String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(@Nullable String name) {
        this.name = name;
    }

    public TdEntity entitytype(@Nullable String entitytype) {
        this.entitytype = entitytype;
        return this;
    }

    @Override
    @Nullable
    @JsonProperty(value="entitytype")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEntitytype() {
        return this.entitytype;
    }

    @Override
    @JsonProperty(value="entitytype")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEntitytype(@Nullable String entitytype) {
        this.entitytype = entitytype;
    }

    public TdEntity subtype(@Nullable String subtype) {
        this.subtype = subtype;
        return this;
    }

    @Nullable
    @JsonProperty(value="subtype")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSubtype() {
        return this.subtype;
    }

    @JsonProperty(value="subtype")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSubtype(@Nullable String subtype) {
        this.subtype = subtype;
    }

    public TdEntity extended(@Nullable Map<String, String> extended) {
        this.extended = extended;
        return this;
    }

    public TdEntity putExtendedItem(String key, String extendedItem) {
        if (this.extended == null) {
            this.extended = new LinkedHashMap<String, String>();
        }
        this.extended.put(key, extendedItem);
        return this;
    }

    @Override
    @Nullable
    @JsonProperty(value="extended")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getExtended() {
        return this.extended;
    }

    @JsonProperty(value="extended")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExtended(@Nullable Map<String, String> extended) {
        this.extended = extended;
    }

    public TdEntity attributes(@Nullable List<TdAttribute> attributes) {
        this.attributes = attributes;
        return this;
    }

    public TdEntity addAttributesItem(TdAttribute attributesItem) {
        if (this.attributes == null) {
            this.attributes = new ArrayList<TdAttribute>();
        }
        this.attributes.add(attributesItem);
        return this;
    }

    @Override
    @Nullable
    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TdAttribute> getAttributes() {
        return this.attributes;
    }

    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAttributes(@Nullable List<TdAttribute> attributes) {
        this.attributes = attributes;
    }

    public TdEntity checks(@Nullable List<TdCheck> checks) {
        this.checks = checks;
        return this;
    }

    public TdEntity addChecksItem(TdCheck checksItem) {
        if (this.checks == null) {
            this.checks = new ArrayList<TdCheck>();
        }
        this.checks.add(checksItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="checks")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TdCheck> getChecks() {
        return this.checks;
    }

    @JsonProperty(value="checks")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChecks(@Nullable List<TdCheck> checks) {
        this.checks = checks;
    }

    public TdEntity ddls(@Nullable List<Ddl> ddls) {
        this.ddls = ddls;
        return this;
    }

    public TdEntity addDdlsItem(Ddl ddlsItem) {
        if (this.ddls == null) {
            this.ddls = new ArrayList<Ddl>();
        }
        this.ddls.add(ddlsItem);
        return this;
    }

    @Override
    @Nullable
    @JsonProperty(value="ddls")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Ddl> getDdls() {
        return this.ddls;
    }

    @JsonProperty(value="ddls")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDdls(@Nullable List<Ddl> ddls) {
        this.ddls = ddls;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TdEntity tdEntity = (TdEntity)o;
        return Objects.equals(this.name, tdEntity.name) && Objects.equals(this.entitytype, tdEntity.entitytype) && Objects.equals(this.subtype, tdEntity.subtype) && Objects.equals(this.extended, tdEntity.extended) && Objects.equals(this.attributes, tdEntity.attributes) && Objects.equals(this.checks, tdEntity.checks) && Objects.equals(this.ddls, tdEntity.ddls);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.entitytype, this.subtype, this.extended, this.attributes, this.checks, this.ddls);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TdEntity {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    entitytype: ").append(this.toIndentedString(this.entitytype)).append("\n");
        sb.append("    subtype: ").append(this.toIndentedString(this.subtype)).append("\n");
        sb.append("    extended: ").append(this.toIndentedString(this.extended)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    checks: ").append(this.toIndentedString(this.checks)).append("\n");
        sb.append("    ddls: ").append(this.toIndentedString(this.ddls)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getName() != null) {
            try {
                joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getName()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getEntitytype() != null) {
            try {
                joiner.add(String.format("%sentitytype%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getEntitytype()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getSubtype() != null) {
            try {
                joiner.add(String.format("%ssubtype%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getSubtype()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getExtended() != null) {
            for (String _key : this.getExtended().keySet()) {
                try {
                    joiner.add(String.format("%sextended%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix), this.getExtended().get(_key), URLEncoder.encode(String.valueOf(this.getExtended().get(_key)), "UTF-8").replaceAll("\\+", "%20")));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getAttributes() != null) {
            for (int i = 0; i < this.getAttributes().size(); ++i) {
                if (this.getAttributes().get(i) == null) continue;
                joiner.add(this.getAttributes().get(i).toUrlQueryString(String.format("%sattributes%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getChecks() != null) {
            for (int i = 0; i < this.getChecks().size(); ++i) {
                if (this.getChecks().get(i) == null) continue;
                joiner.add(this.getChecks().get(i).toUrlQueryString(String.format("%schecks%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getDdls() != null) {
            for (int i = 0; i < this.getDdls().size(); ++i) {
                if (this.getDdls().get(i) == null) continue;
                joiner.add(this.getDdls().get(i).toUrlQueryString(String.format("%sddls%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        return joiner.toString();
    }
}

