/*
 * Decompiled with CFR 0.152.
 */
package giis.tdrules.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import giis.tdrules.openapi.model.TdSchema;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"query", "schema", "options"})
public class TdRulesBody {
    public static final String JSON_PROPERTY_QUERY = "query";
    @Nullable
    private String query = "";
    public static final String JSON_PROPERTY_SCHEMA = "schema";
    @Nullable
    private TdSchema schema;
    public static final String JSON_PROPERTY_OPTIONS = "options";
    @Nullable
    private String options = "";

    public TdRulesBody query(@Nullable String query) {
        this.query = query;
        return this;
    }

    @Nullable
    @JsonProperty(value="query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getQuery() {
        return this.query;
    }

    @JsonProperty(value="query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setQuery(@Nullable String query) {
        this.query = query;
    }

    public TdRulesBody schema(@Nullable TdSchema schema) {
        this.schema = schema;
        return this;
    }

    @Nullable
    @JsonProperty(value="schema")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TdSchema getSchema() {
        return this.schema;
    }

    @JsonProperty(value="schema")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSchema(@Nullable TdSchema schema) {
        this.schema = schema;
    }

    public TdRulesBody options(@Nullable String options) {
        this.options = options;
        return this;
    }

    @Nullable
    @JsonProperty(value="options")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOptions() {
        return this.options;
    }

    @JsonProperty(value="options")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOptions(@Nullable String options) {
        this.options = options;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TdRulesBody tdRulesBody = (TdRulesBody)o;
        return Objects.equals(this.query, tdRulesBody.query) && Objects.equals(this.schema, tdRulesBody.schema) && Objects.equals(this.options, tdRulesBody.options);
    }

    public int hashCode() {
        return Objects.hash(this.query, this.schema, this.options);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TdRulesBody {\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    schema: ").append(this.toIndentedString(this.schema)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getQuery() != null) {
            try {
                joiner.add(String.format("%squery%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getQuery()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getSchema() != null) {
            joiner.add(this.getSchema().toUrlQueryString(prefix + JSON_PROPERTY_SCHEMA + suffix));
        }
        if (this.getOptions() != null) {
            try {
                joiner.add(String.format("%soptions%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getOptions()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }
}

