/*
 * Decompiled with CFR 0.152.
 */
package giis.tdrules.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"serviceVersion", "apiVersion", "environment"})
public class VersionBody {
    public static final String JSON_PROPERTY_SERVICE_VERSION = "serviceVersion";
    @Nullable
    private String serviceVersion = "";
    public static final String JSON_PROPERTY_API_VERSION = "apiVersion";
    @Nullable
    private String apiVersion = "";
    public static final String JSON_PROPERTY_ENVIRONMENT = "environment";
    @Nullable
    private String environment = "";

    public VersionBody serviceVersion(@Nullable String serviceVersion) {
        this.serviceVersion = serviceVersion;
        return this;
    }

    @Nullable
    @JsonProperty(value="serviceVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getServiceVersion() {
        return this.serviceVersion;
    }

    @JsonProperty(value="serviceVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setServiceVersion(@Nullable String serviceVersion) {
        this.serviceVersion = serviceVersion;
    }

    public VersionBody apiVersion(@Nullable String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Nullable
    @JsonProperty(value="apiVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getApiVersion() {
        return this.apiVersion;
    }

    @JsonProperty(value="apiVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setApiVersion(@Nullable String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public VersionBody environment(@Nullable String environment) {
        this.environment = environment;
        return this;
    }

    @Nullable
    @JsonProperty(value="environment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEnvironment() {
        return this.environment;
    }

    @JsonProperty(value="environment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEnvironment(@Nullable String environment) {
        this.environment = environment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionBody versionBody = (VersionBody)o;
        return Objects.equals(this.serviceVersion, versionBody.serviceVersion) && Objects.equals(this.apiVersion, versionBody.apiVersion) && Objects.equals(this.environment, versionBody.environment);
    }

    public int hashCode() {
        return Objects.hash(this.serviceVersion, this.apiVersion, this.environment);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VersionBody {\n");
        sb.append("    serviceVersion: ").append(this.toIndentedString(this.serviceVersion)).append("\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    environment: ").append(this.toIndentedString(this.environment)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getServiceVersion() != null) {
            try {
                joiner.add(String.format("%sserviceVersion%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getServiceVersion()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getApiVersion() != null) {
            try {
                joiner.add(String.format("%sapiVersion%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getApiVersion()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getEnvironment() != null) {
            try {
                joiner.add(String.format("%senvironment%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getEnvironment()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }
}

