/*
 * Decompiled with CFR 0.152.
 */
package giis.tdrules.store.dtypes;

import giis.portable.util.JavaCs;
import giis.tdrules.store.dtypes.OaDataTypes;
import giis.tdrules.store.dtypes.SqlDataTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public abstract class DataTypes {
    public static final String OA_DBMS_VENDOR_NAME = "openapi";
    public static final int DT_UNKNOWN = -1;
    public static final int DT_CHARACTER = 0;
    public static final int DT_INTEGER = 1;
    public static final int DT_EXACT_NUMERIC = 2;
    public static final int DT_APPROXIMATE_NUMERIC = 3;
    public static final int DT_LOGICAL = 4;
    public static final int DT_DATE = 5;
    public static final int DT_TIME = 6;
    public static final int DT_DATETIME = 7;
    public static final int DT_INTERVAL = 8;
    public static final int DT_BLOB = 9;
    private Map<Integer, String[]> typesById = new TreeMap<Integer, String[]>();
    private Map<String, Integer> idsByType = new TreeMap<String, Integer>();
    private String[] allTypesArray;

    public static DataTypes get(String dbmsName) {
        if (OA_DBMS_VENDOR_NAME.equals(dbmsName = dbmsName.toLowerCase())) {
            return new OaDataTypes();
        }
        return new SqlDataTypes();
    }

    protected DataTypes() {
        ArrayList<String> allTypes = new ArrayList<String>();
        this.configureAllIds(allTypes);
        this.allTypesArray = JavaCs.toArray(allTypes);
    }

    protected abstract void configureAllIds(List<String> var1);

    public abstract String getDefault();

    protected void configureId(List<String> allTypes, int id, String[] typesOfId) {
        this.typesById.put(id, typesOfId);
        for (String item : typesOfId) {
            this.idsByType.put(item, id);
            allTypes.add(item);
        }
    }

    public int getId(String name) {
        if (this.idsByType.containsKey(name = name.toLowerCase())) {
            return this.idsByType.get(name);
        }
        return -1;
    }

    public String[] getTypes(int id) {
        String[] types = this.typesById.get(id);
        return types == null ? new String[]{} : types;
    }

    public String[] getAll() {
        return this.allTypesArray;
    }

    public boolean isOneOf(String dataType, int[] ids) {
        for (int id : ids) {
            if (this.getId(dataType.toLowerCase()) != id) continue;
            return true;
        }
        return false;
    }
}

