/*
 * Decompiled with CFR 0.152.
 */
package giis.tdrules.store.ids;

import giis.tdrules.store.ids.Quotation;
import giis.tdrules.store.ids.SimpleIdentifier;
import giis.tdrules.store.ids.TableIdentifier;

public class ColumnIdentifier
extends SimpleIdentifier {
    private TableIdentifier tabId = null;
    private String col = "";

    public ColumnIdentifier(String defCat, String defSch, String name, boolean processQuotes) {
        String[] comp = Quotation.splitQuotedRight(name, '\"', '\"', '.', 4);
        this.col = ColumnIdentifier.processIdentifier(comp[3], processQuotes);
        if (!comp[2].equals("")) {
            this.tabId = new TableIdentifier(defCat, defSch, comp[0], comp[1], comp[2], processQuotes);
        }
    }

    public String getCol() {
        return this.col;
    }

    public TableIdentifier getTabId() {
        return this.tabId;
    }

    public boolean isQualifiedByTable() {
        return this.tabId != null;
    }

    public String getDefaultQualifiedColumnName(String defCat, String defSch) {
        String qTable = "";
        if (this.tabId != null) {
            qTable = this.tabId.getDefaultQualifiedTableName(defCat, defSch) + ".";
        }
        return qTable + this.col;
    }
}

