/*
 * Decompiled with CFR 0.152.
 */
package giis.tdrules.store.ids;

import giis.portable.util.JavaCs;
import java.util.ArrayList;

public class Quotation {
    private Quotation() {
        throw new IllegalAccessError("Utility class");
    }

    public static boolean isQuoted(String str, char openQuote, char closeQuote) {
        return str.length() >= 2 && JavaCs.charAt((String)str, (int)0) == openQuote && JavaCs.charAt((String)str, (int)(str.length() - 1)) == closeQuote;
    }

    public static String removeQuotes(String str, char openQuote, char closeQuote) {
        if (!JavaCs.isEmpty((String)str) && JavaCs.charAt((String)str, (int)0) == openQuote) {
            str = JavaCs.substring((String)str, (int)1);
        }
        if (!JavaCs.isEmpty((String)str) && JavaCs.charAt((String)str, (int)(str.length() - 1)) == closeQuote) {
            str = JavaCs.substring((String)str, (int)0, (int)(str.length() - 1));
        }
        return str;
    }

    public static String[] splitQuoted(String str, char openQuote, char closeQuote, char separator) {
        char[] sepArray = new char[]{separator};
        return Quotation.splitQuoted(str, openQuote, closeQuote, sepArray);
    }

    public static String[] splitQuotedRight(String str, char openQuote, char closeQuote, char separator, int size) {
        String[] dest = new String[size];
        for (int i = 0; i < dest.length; ++i) {
            dest[i] = "";
        }
        if ("".equals(str)) {
            throw new RuntimeException("Quotation.splitQuotedRight: Name is empty");
        }
        String[] comp = Quotation.splitQuoted(str, openQuote, closeQuote, separator);
        if (comp.length > size) {
            throw new RuntimeException("Quotation.splitQuotedRight: Name has more than " + size + " componentes: " + str);
        }
        for (int i = 0 + size - comp.length; i < dest.length; ++i) {
            dest[i] = comp[i - (size - comp.length)].trim();
        }
        return dest;
    }

    public static String[] splitQuotedWords(String str, char openQuote, char closeQuote) {
        String[] scw1 = Quotation.splitQuoted(str, openQuote, closeQuote, new char[]{' ', '\t', '\n', '\r'});
        ArrayList<String> scw2 = new ArrayList<String>();
        for (int i = 0; i < scw1.length; ++i) {
            if (scw1[i].trim().equals("")) continue;
            scw2.add(scw1[i]);
        }
        return JavaCs.toArray(scw2);
    }

    public static String[] splitQuoted(String str, char openQuote, char closeQuote, char[] separator) {
        boolean inQuote = false;
        ArrayList<Integer> beginChar = new ArrayList<Integer>();
        ArrayList<Integer> endChar = new ArrayList<Integer>();
        int beginCharIndex = 0;
        for (int i = 0; i < str.length(); ++i) {
            char current = JavaCs.charAt((String)str, (int)i);
            boolean isSeparator = false;
            for (int j = 0; j < separator.length; ++j) {
                if (current != separator[j]) continue;
                isSeparator = true;
            }
            if (inQuote && current == closeQuote) {
                inQuote = false;
                continue;
            }
            if (!inQuote && current == openQuote) {
                inQuote = true;
                continue;
            }
            if (!isSeparator || inQuote) continue;
            beginChar.add(beginCharIndex);
            endChar.add(i);
            beginCharIndex = i + 1;
        }
        if (inQuote) {
            throw new RuntimeException("Str.splitQuoted: Quote not closed in string " + str);
        }
        beginChar.add(beginCharIndex);
        endChar.add(str.length());
        String[] res = new String[beginChar.size()];
        for (int i = 0; i < res.length; ++i) {
            String partial;
            int begin = (Integer)beginChar.get(i);
            int end = (Integer)endChar.get(i);
            res[i] = partial = JavaCs.substring((String)str, (int)begin, (int)end);
        }
        return res;
    }
}

