/*
 * Decompiled with CFR 0.152.
 */
package giis.tdrules.store.ids;

import giis.portable.util.JavaCs;
import giis.tdrules.store.ids.Quotation;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SimpleIdentifier {
    private static Pattern pattern;

    protected SimpleIdentifier() {
    }

    public static String processIdentifier(String sid, boolean processQuotes) {
        String id;
        String string = id = sid == null ? "" : sid.trim();
        if (processQuotes) {
            boolean needsQuote;
            boolean quotedWithBrackets = false;
            if (SimpleIdentifier.isQuoted(id)) {
                if (JavaCs.charAt((String)id, (int)0) == '\"') {
                    id = Quotation.removeQuotes(id, '\"', '\"');
                } else if (JavaCs.charAt((String)id, (int)0) == '[') {
                    id = Quotation.removeQuotes(id, '[', ']');
                    quotedWithBrackets = true;
                }
                id = id.trim();
            }
            if ((needsQuote = SimpleIdentifier.needsQuotation(id)) && quotedWithBrackets) {
                id = SimpleIdentifier.getQuotedName(id, "[");
            } else if (needsQuote) {
                id = SimpleIdentifier.getQuotedName(id, "\"");
            }
        }
        return id;
    }

    private static synchronized boolean needsQuotation(String name) {
        if (pattern == null) {
            pattern = Pattern.compile("[^a-z0-9_\\$#]", 2);
        }
        Matcher matcher = pattern.matcher(name);
        return matcher.find();
    }

    public static boolean isQuoted(String name) {
        return Quotation.isQuoted(name, '\"', '\"') || Quotation.isQuoted(name, '[', ']');
    }

    public static String getQuote(String name) {
        if (name.contains("\"")) {
            return "\"";
        }
        if (name.contains("[")) {
            return "[";
        }
        return "";
    }

    public static String getQuotedName(String name, String quoteValue) {
        if (!SimpleIdentifier.isQuoted(name = name.trim())) {
            return quoteValue + name + ("[".equals(quoteValue) ? "]" : quoteValue);
        }
        return name;
    }

    public static String getLastComponent(String name) {
        if (name.contains(".")) {
            String[] components = JavaCs.splitByDot((String)name);
            return components[components.length - 1].trim();
        }
        return name.trim();
    }
}

