/*
 * Decompiled with CFR 0.152.
 */
package giis.tdrules.store.ids;

import giis.portable.util.JavaCs;
import giis.tdrules.store.ids.Quotation;
import giis.tdrules.store.ids.SimpleIdentifier;

public class TableIdentifier
extends SimpleIdentifier {
    private String cat = "";
    private String sch = "";
    private String tab = "";
    private boolean processQuotes = false;

    public TableIdentifier(String defCat, String defSch, String catalog, String schema, String table, boolean processQuotes) {
        this.processQuotes = processQuotes;
        this.fill(defCat, defSch, catalog, schema, table);
    }

    public TableIdentifier(String defCat, String defSch, String name, boolean processQuotes) {
        this.processQuotes = processQuotes;
        String[] comp = name.contains("[") ? Quotation.splitQuotedRight(name, '[', ']', '.', 3) : Quotation.splitQuotedRight(name, '\"', '\"', '.', 3);
        this.fill(defCat, defSch, comp[0], comp[1], comp[2]);
    }

    public TableIdentifier(String name, boolean processQuotes) {
        this("", "", name, processQuotes);
    }

    public String getCat() {
        return this.cat;
    }

    public String getSch() {
        return this.sch;
    }

    public String getTab() {
        return this.tab;
    }

    public void setCat(String cat) {
        this.cat = cat;
    }

    public void setSch(String sch) {
        this.sch = sch;
    }

    public void setTab(String tab) {
        this.tab = tab;
    }

    public String toString() {
        return "cat=" + this.cat + ", sch=" + this.sch + ", tab=" + this.tab;
    }

    private void fill(String defCat, String defSch, String catalog, String schema, String table) {
        this.cat = TableIdentifier.processIdentifier(catalog, this.processQuotes);
        this.sch = TableIdentifier.processIdentifier(schema, this.processQuotes);
        this.tab = TableIdentifier.processIdentifier(table, this.processQuotes);
        if (this.cat.equals("")) {
            this.cat = TableIdentifier.processIdentifier(defCat, this.processQuotes);
        }
        if (this.sch.equals("")) {
            this.sch = TableIdentifier.processIdentifier(defSch, this.processQuotes);
        }
    }

    public String getFullQualifiedTableName(String defCat, String defSch) {
        defCat = TableIdentifier.processIdentifier(defCat, this.processQuotes);
        defSch = TableIdentifier.processIdentifier(defSch, this.processQuotes);
        String catalog = this.cat.equals("") ? defCat : this.cat;
        String schema = this.sch.equals("") ? defSch : this.sch;
        return TableIdentifier.getQualifiedName(catalog, schema, this.tab);
    }

    public String getFullQualifiedTableName() {
        return TableIdentifier.getQualifiedName(this.cat, this.sch, this.tab);
    }

    public String getDefaultQualifiedTableName(String defCat, String defSch) {
        defCat = TableIdentifier.processIdentifier(defCat, this.processQuotes);
        defSch = TableIdentifier.processIdentifier(defSch, this.processQuotes);
        String catalog = JavaCs.equalsIgnoreCase((String)this.cat, (String)defCat) ? "" : this.cat;
        String schema = JavaCs.equalsIgnoreCase((String)this.sch, (String)defSch) ? "" : this.sch;
        return TableIdentifier.getQualifiedName(catalog, schema, this.tab);
    }

    public static String getQualifiedName(String catalog, String schema, String table) {
        if (catalog == null) {
            catalog = "";
        }
        if (schema == null) {
            schema = "";
        }
        if (table == null) {
            table = "";
        }
        if (table.equals("")) {
            throw new RuntimeException("SchemaTableIdentifier.getQualifiedName: table name is empty");
        }
        String name = "";
        if (!catalog.equals("") && !schema.equals("")) {
            name = name + catalog + "." + schema + ".";
        } else if (catalog.equals("") && !schema.equals("")) {
            name = name + schema + ".";
        } else if (!catalog.equals("") && schema.equals("")) {
            name = name + catalog + "..";
        }
        name = name + table;
        return name;
    }
}

