/*
 * Decompiled with CFR 0.152.
 */
package giis.tdrules.store.stypes;

import giis.portable.util.JavaCs;
import giis.tdrules.store.stypes.StoreTypeCassandra;
import giis.tdrules.store.stypes.StoreTypeH2;
import giis.tdrules.store.stypes.StoreTypeMysql;
import giis.tdrules.store.stypes.StoreTypeOpenApi;
import giis.tdrules.store.stypes.StoreTypeOracle;
import giis.tdrules.store.stypes.StoreTypePostgres;
import giis.tdrules.store.stypes.StoreTypeSqlite;
import giis.tdrules.store.stypes.StoreTypeSqlserver;

public class StoreType {
    protected String dbmsVendorName = "";
    private static final String MYSQL = "mysql";
    private static final String SQLITE = "sqlite";
    private static final String H2 = "h2";
    private static final String ORACLE = "oracle";
    private static final String SQLSERVER = "sqlserver";
    private static final String POSTGRES = "postgres";
    private static final String CASSANDRA = "cassandra";
    public static final String DBMS_UNKNOWN_ERROR = "unknown";
    public static final String DBMS_TIMEOUT = "Query timeout";
    public static final String DBMS_DIVIDE_BY_ZERO = "Divisor is equal to zero";
    public static final String DBMS_INVALID_DATE_MONTH = "Date not valid for month specified";

    protected StoreType(String dbms) {
        this.dbmsVendorName = dbms;
    }

    public static StoreType get(String dbms) {
        String productName = dbms.toLowerCase();
        if (productName.equals("openapi")) {
            return new StoreTypeOpenApi("openapi");
        }
        if (productName.equals("microsoft sql server") || productName.equals("microsoft sqlserver") || productName.equals("sql server") || productName.equals(SQLSERVER)) {
            return new StoreTypeSqlserver(SQLSERVER);
        }
        if (productName.equals(ORACLE)) {
            return new StoreTypeOracle(ORACLE);
        }
        if (productName.startsWith(POSTGRES)) {
            return new StoreTypePostgres(POSTGRES);
        }
        if (productName.startsWith(H2)) {
            return new StoreTypeH2(H2);
        }
        if (productName.equals(MYSQL)) {
            return new StoreTypeMysql(MYSQL);
        }
        if (productName.equals("my sql")) {
            return new StoreTypeMysql(MYSQL);
        }
        if (productName.equals(SQLITE)) {
            return new StoreTypeSqlite(SQLITE);
        }
        if (productName.equals(CASSANDRA)) {
            return new StoreTypeCassandra(CASSANDRA);
        }
        return new StoreType(dbms);
    }

    public static StoreType get() {
        return StoreType.get("");
    }

    public String getVendorName() {
        return this.dbmsVendorName;
    }

    public String getName() {
        return this.dbmsVendorName;
    }

    public String toString() {
        return this.dbmsVendorName;
    }

    public boolean equals(StoreType other) {
        if (other == null) {
            throw new RuntimeException("DBMSType.equals+: Type to compare can't be null");
        }
        return JavaCs.equalsIgnoreCase((String)this.toString(), (String)other.toString());
    }

    public boolean isUnknown() {
        return this.dbmsVendorName.equals("");
    }

    public boolean isOracle() {
        return false;
    }

    public boolean isSQLServer() {
        return false;
    }

    public boolean isPostgres() {
        return false;
    }

    public boolean isH2() {
        return false;
    }

    public boolean isMySQL() {
        return false;
    }

    public boolean isSqlite() {
        return false;
    }

    public boolean isCassandra() {
        return false;
    }

    public boolean isOpenApi() {
        return false;
    }

    public String getKnownError(String message) {
        return DBMS_UNKNOWN_ERROR;
    }

    public String sqlBoolean(boolean b) {
        return b ? "(1=1)" : "(1=0)";
    }

    public boolean supportsBracketQuotation() {
        return false;
    }

    public String mapAliasToDataType(String alias) {
        return alias;
    }

    public String sqlCoalesce(String expr, String sust) {
        return this.sqlCoalesceFunctionName().toUpperCase() + "(" + expr + "," + sust + ")";
    }

    public String sqlCoalesceFunctionName() {
        return "coalesce";
    }

    public String sqlDropView() {
        return "DROP VIEW";
    }

    public String getDataTypeIdentity(String baseType) {
        return baseType;
    }

    public String getDataTypeIdentitySuffix() {
        return "";
    }

    public String getDataTypeIdentitySql(String tableName, String columnName) {
        return "";
    }

    public String getEnableIdentityCommand(String tableName) {
        return "";
    }

    public String getDisableIdentityCommand(String tableName) {
        return "";
    }

    public boolean canDisableForeignKey() {
        return false;
    }

    public String getEnableForeignKeyCommand(String tableName, String fkName) {
        return "";
    }

    public String getDisableForeignKeyCommand(String tableName, String fkName) {
        return "";
    }

    public String getDisableConstraintsCommand(String tableName) {
        return "";
    }

    public String getEnableConstraintsCommand(String tableName) {
        return "";
    }

    public String getEndSQLQueryChar() {
        return ";";
    }

    public String getEndSQLBlockCommand() {
        return "";
    }

    public String getSortNullsFirst() {
        return "NULLS FIRST";
    }

    public String getSortNullsLast() {
        return "NULLS LAST";
    }

    public boolean getAliasInOrderByAllowed() {
        return false;
    }

    public boolean getAliasInDerivedTableRequired() {
        return true;
    }

    public boolean getSupportsHavingWithoutGroupBy() {
        return true;
    }

    public boolean getSupportsRightJoin() {
        return true;
    }

    public String getViewDefinitionSQL(String catalog, String schema, String viewName) {
        if (catalog == null) {
            catalog = "";
        }
        if (schema == null) {
            schema = "";
        }
        String sql = "SELECT CAST(VIEW_DEFINITION AS VARCHAR(4000)) AS VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS WHERE";
        if (!catalog.equals("")) {
            sql = sql + " TABLE_CATALOG='" + catalog + "' AND ";
        }
        if (!schema.equals("")) {
            sql = sql + " TABLE_SCHEMA='" + schema + "' AND ";
        }
        sql = sql + " TABLE_NAME='" + viewName + "'";
        return sql;
    }

    public boolean isSystemSchema(String schemaName) {
        return false;
    }

    public boolean isSystemTable(String tableName) {
        return false;
    }

    public boolean isSystemView(String viewName) {
        return false;
    }

    public String getMaxRowCondition(long maxRows) {
        return "";
    }

    public String getMaxRowSelectClause(long maxRows) {
        return "";
    }

    public String getMaxRowsLimitClause(long maxRows) {
        return "";
    }

    public String getSqlLimitRows(String sql, long maxRows) {
        return sql;
    }

    public String getRankFunctionInGroup() {
        return "";
    }

    public boolean getSupportsPartitionBy(int version) {
        return false;
    }

    public String getSQLSubstring(String str, int start, int length) {
        return "substring(" + str + "," + start + "," + length + ")";
    }

    public String getSQLStringConcat() {
        return "+";
    }

    public String getDataTypeDatetime() {
        return "timestamp";
    }

    public String getSqlDatetimeLiteral(String sDate, String sTime) {
        if (sDate.contains("T")) {
            return this.sqlString(sDate);
        }
        if ("".equals(sTime)) {
            return this.sqlString(sDate);
        }
        if ("".equals(sDate)) {
            return this.sqlString(sTime);
        }
        return this.sqlString(sDate + "T" + sTime);
    }

    public String getSqlDatetimeColumnString(String sCol) {
        return sCol;
    }

    public String getSqlDateColumnString(String sCol) {
        return sCol;
    }

    protected String sqlString(String s) {
        return "'" + s.replace("'", "''").trim() + "'";
    }
}

