/*
 * Decompiled with CFR 0.152.
 */
package giis.tdrules.store.stypes;

import giis.tdrules.store.stypes.StoreType;

public class StoreTypeOracle
extends StoreType {
    public StoreTypeOracle(String dbms) {
        super(dbms);
    }

    @Override
    public boolean isOracle() {
        return true;
    }

    @Override
    public boolean canDisableForeignKey() {
        return true;
    }

    @Override
    public String getEnableForeignKeyCommand(String tableName, String fkName) {
        return "ALTER TABLE " + tableName + " ENABLE CONSTRAINT " + fkName;
    }

    @Override
    public String getDisableForeignKeyCommand(String tableName, String fkName) {
        return "ALTER TABLE " + tableName + " DISABLE CONSTRAINT " + fkName;
    }

    @Override
    public boolean getAliasInOrderByAllowed() {
        return true;
    }

    @Override
    public String getKnownError(String message) {
        if (message.contains("ORA-01013")) {
            return "Query timeout";
        }
        if (message.contains("ORA-01476")) {
            return "Divisor is equal to zero";
        }
        if (message.contains("ORA-01839")) {
            return "Date not valid for month specified";
        }
        return "unknown";
    }

    @Override
    public String getViewDefinitionSQL(String catalog, String schema, String viewName) {
        String sql = "SELECT TEXT AS VIEW_DEFINITION FROM USER_VIEWS WHERE";
        sql = sql + " VIEW_NAME='" + viewName + "'";
        return sql;
    }

    @Override
    public boolean isSystemTable(String tableName) {
        return tableName.length() >= 4 && (tableName.startsWith("BIN$") || tableName.startsWith("JAVA$") || tableName.startsWith("CREATE$JAVA$"));
    }

    @Override
    public boolean getAliasInDerivedTableRequired() {
        return false;
    }

    @Override
    public String getMaxRowCondition(long maxRows) {
        return "ROWNUM <= " + maxRows;
    }

    @Override
    public String getSqlLimitRows(String sql, long maxRows) {
        return "SELECT * FROM (" + sql + ") WHERE " + this.getMaxRowCondition(maxRows);
    }

    @Override
    public String getRankFunctionInGroup() {
        return "row_number()";
    }

    public boolean getSupportsPartitionBy() {
        return true;
    }

    @Override
    public boolean getSupportsPartitionBy(int version) {
        return version >= 8;
    }

    @Override
    public String getSQLSubstring(String str, int start, int length) {
        return "substr(" + str + "," + start + "," + length + ")";
    }

    @Override
    public String getSQLStringConcat() {
        return "||";
    }

    @Override
    public String getSqlDatetimeLiteral(String sDate, String sTime) {
        if (sDate.contains("T")) {
            return "TIMESTAMP " + this.sqlString(sDate).replace("T", " ");
        }
        if ("".equals(sTime)) {
            return "DATE " + this.sqlString(sDate);
        }
        if ("".equals(sDate)) {
            return "INTERVAL " + this.sqlString(sTime);
        }
        return "TIMESTAMP " + this.sqlString(sDate + " " + sTime);
    }

    @Override
    public String getSqlDatetimeColumnString(String sCol) {
        return "TO_CHAR(" + sCol + ", 'YYYY-MM-DD HH24:MI:SS')";
    }

    @Override
    public String getSqlDateColumnString(String sCol) {
        return "TO_CHAR(" + sCol + ", 'YYYY-MM-DD')";
    }
}

