/*
 * Decompiled with CFR 0.152.
 */
package giis.tdrules.store.stypes;

import giis.portable.util.JavaCs;
import giis.tdrules.store.stypes.StoreType;
import java.util.HashMap;
import java.util.Map;

public class StoreTypePostgres
extends StoreType {
    private Map<String, String> aliasMap = null;

    public StoreTypePostgres(String dbms) {
        super(dbms);
    }

    @Override
    public boolean isPostgres() {
        return true;
    }

    @Override
    public String getDisableConstraintsCommand(String tableName) {
        return "ALTER TABLE " + tableName + " DISABLE TRIGGER ALL";
    }

    @Override
    public String getEnableConstraintsCommand(String tableName) {
        return "ALTER TABLE " + tableName + " ENABLE TRIGGER ALL";
    }

    @Override
    public String getDataTypeIdentity(String baseType) {
        return "serial";
    }

    @Override
    public String getViewDefinitionSQL(String catalog, String schema, String viewName) {
        return "select definition from pg_views where viewname = '" + viewName + "'";
    }

    @Override
    public String mapAliasToDataType(String alias) {
        if (this.aliasMap == null) {
            this.aliasMap = new HashMap<String, String>();
            this.aliasMap.put("int2", "smallint");
            this.aliasMap.put("int4", "integer");
            this.aliasMap.put("int", "integer");
            this.aliasMap.put("int8", "bigint");
            this.aliasMap.put("serial2", "smallserial");
            this.aliasMap.put("serial4", "serial");
            this.aliasMap.put("serial8", "bigserial");
            this.aliasMap.put("decimal", "numeric");
            this.aliasMap.put("float4", "real");
            this.aliasMap.put("float8", "double precision");
            this.aliasMap.put("bpchar", "char");
            this.aliasMap.put("bool", "boolean");
            this.aliasMap.put("timetz", "time with time zone");
            this.aliasMap.put("timestamptz", "timestamp with time zone");
        }
        if (alias.startsWith("_")) {
            alias = JavaCs.substring((String)alias, (int)1, (int)alias.length());
        }
        if (this.aliasMap.containsKey(alias)) {
            return this.aliasMap.get(alias);
        }
        return alias;
    }

    @Override
    public String getMaxRowsLimitClause(long maxRows) {
        return "LIMIT " + maxRows;
    }
}

