/*
 * Decompiled with CFR 0.152.
 */
package giis.tdrules.store.stypes;

import giis.portable.util.JavaCs;
import giis.tdrules.store.stypes.StoreType;

public class StoreTypeSqlserver
extends StoreType {
    public StoreTypeSqlserver(String dbms) {
        super(dbms);
    }

    @Override
    public boolean isSQLServer() {
        return true;
    }

    @Override
    public boolean supportsBracketQuotation() {
        return true;
    }

    @Override
    public boolean canDisableForeignKey() {
        return true;
    }

    @Override
    public String getEnableIdentityCommand(String tableName) {
        return "SET IDENTITY_INSERT " + tableName + " ON";
    }

    @Override
    public String getDisableIdentityCommand(String tableName) {
        return "SET IDENTITY_INSERT " + tableName + " OFF";
    }

    @Override
    public String getEnableForeignKeyCommand(String tableName, String fkName) {
        return "ALTER TABLE " + tableName + " CHECK CONSTRAINT " + fkName;
    }

    @Override
    public String getDisableForeignKeyCommand(String tableName, String fkName) {
        return "ALTER TABLE " + tableName + " NOCHECK CONSTRAINT " + fkName;
    }

    @Override
    public String getEndSQLQueryChar() {
        return "";
    }

    @Override
    public String getEndSQLBlockCommand() {
        return "GO";
    }

    @Override
    public boolean getAliasInOrderByAllowed() {
        return false;
    }

    @Override
    public String getDataTypeIdentitySuffix() {
        return "identity";
    }

    @Override
    public String getDataTypeIdentitySql(String tableName, String columnName) {
        return "select name from sys.identity_columns where [object_id] = object_id('" + tableName + "') and name = '" + columnName + "'";
    }

    @Override
    public String getViewDefinitionSQL(String catalog, String schema, String viewName) {
        String catSchema = "";
        if (catalog != null && !"".equals(catalog)) {
            catSchema = catSchema + catalog + ".";
        }
        if (schema != null && !"".equals(schema)) {
            catSchema = catSchema + schema + ".";
        }
        String sql = "SELECT definition AS VIEW_DEFINITION FROM sys.objects o";
        sql = sql + " JOIN sys.sql_modules m on m.object_id = o.object_id WHERE";
        sql = sql + " o.object_id = object_id('" + catSchema + viewName + "') and o.type = 'V'";
        return sql;
    }

    @Override
    public boolean isSystemSchema(String schemaName) {
        return JavaCs.equalsIgnoreCase((String)schemaName, (String)"information_schema") || JavaCs.equalsIgnoreCase((String)schemaName, (String)"sys");
    }

    @Override
    public boolean isSystemTable(String tableName) {
        return JavaCs.equalsIgnoreCase((String)tableName, (String)"sysdiagrams");
    }

    @Override
    public boolean isSystemView(String viewName) {
        return JavaCs.equalsIgnoreCase((String)viewName, (String)"sysconstraints") || JavaCs.equalsIgnoreCase((String)viewName, (String)"syssegments");
    }

    @Override
    public String getMaxRowSelectClause(long maxRows) {
        return "TOP " + maxRows;
    }

    @Override
    public String getSqlLimitRows(String sql, long maxRows) {
        return "SELECT " + this.getMaxRowSelectClause(maxRows) + " * FROM (" + sql + ") X";
    }

    @Override
    public String getRankFunctionInGroup() {
        return "rank()";
    }

    @Override
    public boolean getSupportsPartitionBy(int version) {
        return version >= 9;
    }

    @Override
    public String getDataTypeDatetime() {
        return "datetime";
    }

    @Override
    public String getSqlDatetimeLiteral(String sDate, String sTime) {
        if (sDate.contains("T")) {
            return this.sqlString(sDate);
        }
        if ("".equals(sTime)) {
            return this.sqlString(sDate.replace("-", ""));
        }
        if ("".equals(sDate)) {
            return this.sqlString(sTime);
        }
        return this.sqlString(sDate + "T" + sTime);
    }

    @Override
    public String getSqlDatetimeColumnString(String sCol) {
        return "CONVERT(CHAR(19)," + sCol + ",120)";
    }

    @Override
    public String getSqlDateColumnString(String sCol) {
        return "CONVERT(CHAR(10)," + sCol + ",23)";
    }
}

