/*
 * Decompiled with CFR 0.152.
 */
package io.github.giovannilamarmora.utils.config;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import com.google.cloud.logging.LogEntry;
import com.google.cloud.logging.Payload;
import com.google.cloud.logging.Severity;
import com.google.cloud.logging.logback.LoggingEventEnhancer;
import io.github.giovannilamarmora.utils.context.AppContext;
import io.github.giovannilamarmora.utils.context.ContextConfig;
import io.github.giovannilamarmora.utils.context.TraceUtils;
import io.github.giovannilamarmora.utils.utilities.ObjectToolkit;
import java.util.HashMap;

public class GoogleLogConfig
implements LoggingEventEnhancer {
    public void enhanceLogEntry(LogEntry.Builder logEntry, ILoggingEvent e) {
        logEntry.setSeverity(this.mapSeverity(e.getLevel()));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("thread", e.getThreadName());
        map.put("context", e.getLoggerContextVO().getName());
        map.put("logger", e.getLoggerName());
        HashMap mdcValues = new HashMap(e.getMDCPropertyMap());
        mdcValues.remove(ContextConfig.ENV.getValue());
        mdcValues.remove(ContextConfig.APP_NAME.getValue());
        mdcValues.remove(ContextConfig.APP_VERSION.getValue());
        map.put("mdc", mdcValues);
        Payload.JsonPayload payload = (Payload.JsonPayload)logEntry.build().getPayload();
        map.putAll(payload.getDataAsMap());
        IThrowableProxy throwableProxy = e.getThrowableProxy();
        if (!ObjectToolkit.isNullOrEmpty(throwableProxy)) {
            map.put("exception_message", throwableProxy.getMessage());
            StackTraceElementProxy[] stackTraceElements = throwableProxy.getStackTraceElementProxyArray();
            if (stackTraceElements != null && stackTraceElements.length > 0) {
                StackTraceElement firstElement = stackTraceElements[0].getStackTraceElement();
                map.put("error_class", firstElement.getClassName());
                map.put("error_method", firstElement.getMethodName());
                map.put("error_line", firstElement.getLineNumber());
            }
        }
        try {
            map.put(ContextConfig.ENV.getValue(), TraceUtils.getEnvironment());
        }
        catch (Exception stackTraceElements) {
            // empty catch block
        }
        try {
            map.put(ContextConfig.APP_NAME.getValue(), AppContext.getApplicationName());
        }
        catch (Exception stackTraceElements) {
            // empty catch block
        }
        try {
            map.put(ContextConfig.APP_VERSION.getValue(), AppContext.getApplicationVersion());
        }
        catch (Exception stackTraceElements) {
            // empty catch block
        }
        logEntry.setPayload((Payload)Payload.JsonPayload.of(map));
        try {
            logEntry.setTrace(TraceUtils.getTraceID());
        }
        catch (Exception exception) {
            logEntry.addLabel(ContextConfig.TRACE_ID.getValue(), exception.getMessage());
        }
        try {
            logEntry.setSpanId(TraceUtils.getSpanID());
        }
        catch (Exception exception) {
            logEntry.addLabel(ContextConfig.SPAN_ID.getValue(), exception.getMessage());
        }
        try {
            logEntry.addLabel(ContextConfig.ENV.getValue(), TraceUtils.getEnvironment());
        }
        catch (Exception exception) {
            logEntry.addLabel(ContextConfig.ENV.getValue(), exception.getMessage());
        }
    }

    private Severity mapSeverity(Level level) {
        return switch (level.toInt()) {
            case 40000 -> Severity.ERROR;
            case 30000 -> Severity.WARNING;
            case 20000 -> Severity.INFO;
            case 5000, 10000 -> Severity.DEBUG;
            default -> Severity.DEFAULT;
        };
    }
}

