/*
 * Decompiled with CFR 0.152.
 */
package io.github.giovannilamarmora.utils.context;

import io.github.giovannilamarmora.utils.context.ContextConfig;
import io.github.giovannilamarmora.utils.context.TraceUtils;
import io.github.giovannilamarmora.utils.logger.LoggerFilter;
import io.github.giovannilamarmora.utils.logger.MDCUtils;
import io.github.giovannilamarmora.utils.web.CookieManager;
import io.github.giovannilamarmora.utils.web.ResponseManager;
import io.github.giovannilamarmora.utils.web.WebManager;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;

@Component
@Order(value=-2147483648)
public class TracingFilter
implements WebFilter {
    @Value(value="${env:Default}")
    private String env;
    @Value(value="${spring.application.name:no_name_defined}")
    private String application_name;
    @Value(value="${app.version:no_version_defined}")
    private String app_version;
    @Value(value="${cookie-domain:}")
    private String cookieDomain;
    private static final Logger LOG = LoggerFilter.getLogger(TracingFilter.class);
    private static final Pattern TRACE_ID_PATTERN = Pattern.compile(".*trace-id.*", 2);
    private static final Pattern SPAN_ID_PATTERN = Pattern.compile(".*span-id.*", 2);
    private static final Pattern PARENT_ID_PATTERN = Pattern.compile(".*parent-id.*", 2);
    @Value(value="${filter.requestResponse.shouldNotFilter}")
    private List<String> shouldNotFilter;

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        ServerHttpRequest request = exchange.getRequest();
        ServerHttpResponse response = exchange.getResponse();
        if (WebManager.shouldNotFilter(request, this.shouldNotFilter)) {
            return chain.filter(exchange);
        }
        String traceId = this.getOrGenerateId(request, TRACE_ID_PATTERN, ContextConfig.TRACE_ID.getValue());
        String spanId = TraceUtils.generateTrace();
        String parentId = this.getOrGenerateId(request, SPAN_ID_PATTERN, ContextConfig.SPAN_ID.getValue());
        ResponseManager.setCookieAndHeaderData(ContextConfig.TRACE_ID.getValue(), traceId, this.cookieDomain, response);
        ResponseManager.setCookieAndHeaderData(ContextConfig.SPAN_ID.getValue(), spanId, this.cookieDomain, response);
        ResponseManager.setCookieAndHeaderData(ContextConfig.PARENT_ID.getValue(), parentId, this.cookieDomain, response);
        return Mono.fromRunnable(() -> {
            MDCUtils.setDataIntoMDC(ContextConfig.TRACE_ID.getValue(), traceId);
            MDCUtils.setDataIntoMDC(ContextConfig.SPAN_ID.getValue(), spanId);
            MDCUtils.setDataIntoMDC(ContextConfig.PARENT_ID.getValue(), parentId);
            MDCUtils.setDataIntoMDC(ContextConfig.ENV.getValue(), this.env);
            MDCUtils.setDataIntoMDC(ContextConfig.APP_NAME.getValue(), this.application_name);
            MDCUtils.setDataIntoMDC(ContextConfig.APP_VERSION.getValue(), this.app_version);
        }).then(chain.filter(exchange).contextWrite(context -> {
            HashMap<String, String> contextMap = new HashMap<String, String>();
            contextMap.put(ContextConfig.TRACE_ID.getValue(), traceId);
            contextMap.put(ContextConfig.SPAN_ID.getValue(), spanId);
            contextMap.put(ContextConfig.PARENT_ID.getValue(), parentId);
            contextMap.put(ContextConfig.ENV.getValue(), this.env);
            contextMap.put(ContextConfig.APP_NAME.getValue(), this.application_name);
            contextMap.put(ContextConfig.APP_VERSION.getValue(), this.app_version);
            return Context.of(contextMap);
        })).doFinally(signalType -> MDC.clear());
    }

    private String getOrGenerateId(ServerHttpRequest request, Pattern pattern, String defaultHeaderName) {
        return this.getHeaderValue(request.getHeaders(), pattern).orElseGet(() -> Optional.ofNullable(CookieManager.getCookie(defaultHeaderName, request)).orElseGet(TraceUtils::generateTrace));
    }

    private Optional<String> getHeaderValue(HttpHeaders headers, Pattern pattern) {
        return headers.entrySet().stream().filter(entry -> pattern.matcher((CharSequence)entry.getKey()).matches()).findFirst().map(entry -> (String)((List)entry.getValue()).getFirst());
    }
}

