/*
 * Decompiled with CFR 0.152.
 */
package io.github.giovannilamarmora.utils.exception.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import io.github.giovannilamarmora.utils.exception.dto.ErrorInfo;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ExceptionResponse
implements Serializable {
    @JsonSerialize(using=LocalDateTimeSerializer.class)
    @JsonDeserialize(using=LocalDateTimeDeserializer.class)
    private LocalDateTime dateTime;
    private String url;
    private String spanId;
    private ErrorInfo error;

    public ExceptionResponse(ErrorInfo error) {
        this.dateTime = this.getDateTime();
        this.error = error;
    }

    public ExceptionResponse(String url, String spanId, ErrorInfo error) {
        this.dateTime = this.getDateTime();
        this.url = url;
        this.spanId = spanId;
        this.error = error;
    }

    public LocalDateTime getDateTime() {
        return LocalDateTime.now().truncatedTo(ChronoUnit.SECONDS);
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public String getSpanId() {
        return this.spanId;
    }

    @Generated
    public ErrorInfo getError() {
        return this.error;
    }

    @JsonDeserialize(using=LocalDateTimeDeserializer.class)
    @Generated
    public void setDateTime(LocalDateTime dateTime) {
        this.dateTime = dateTime;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public void setSpanId(String spanId) {
        this.spanId = spanId;
    }

    @Generated
    public void setError(ErrorInfo error) {
        this.error = error;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExceptionResponse)) {
            return false;
        }
        ExceptionResponse other = (ExceptionResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        LocalDateTime this$dateTime = this.getDateTime();
        LocalDateTime other$dateTime = other.getDateTime();
        if (this$dateTime == null ? other$dateTime != null : !((Object)this$dateTime).equals(other$dateTime)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$spanId = this.getSpanId();
        String other$spanId = other.getSpanId();
        if (this$spanId == null ? other$spanId != null : !this$spanId.equals(other$spanId)) {
            return false;
        }
        ErrorInfo this$error = this.getError();
        ErrorInfo other$error = other.getError();
        return !(this$error == null ? other$error != null : !((Object)this$error).equals(other$error));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ExceptionResponse;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LocalDateTime $dateTime = this.getDateTime();
        result = result * 59 + ($dateTime == null ? 43 : ((Object)$dateTime).hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $spanId = this.getSpanId();
        result = result * 59 + ($spanId == null ? 43 : $spanId.hashCode());
        ErrorInfo $error = this.getError();
        result = result * 59 + ($error == null ? 43 : ((Object)$error).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ExceptionResponse(dateTime=" + String.valueOf(this.getDateTime()) + ", url=" + this.getUrl() + ", spanId=" + this.getSpanId() + ", error=" + String.valueOf(this.getError()) + ")";
    }

    @Generated
    public ExceptionResponse() {
    }

    @Generated
    public ExceptionResponse(LocalDateTime dateTime, String url, String spanId, ErrorInfo error) {
        this.dateTime = dateTime;
        this.url = url;
        this.spanId = spanId;
        this.error = error;
    }
}

