/*
 * Decompiled with CFR 0.152.
 */
package io.github.giovannilamarmora.utils.logger;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class LoggerFilter
implements Logger {
    private String SENSITIVE_DATA = "password|bearer|basic|token|Bearer|Basic|Authorization|access_token|accessToken|refresh_token|refreshToken|jwt";
    private Logger logger;

    public LoggerFilter() {
    }

    private LoggerFilter(Class<?> clazz) {
        this.logger = LoggerFactory.getLogger(clazz);
    }

    public void setSensitiveData(String sensitiveData) {
        this.SENSITIVE_DATA = sensitiveData;
    }

    public static Logger getLogger(Class<?> clazz) {
        return new LoggerFilter(clazz);
    }

    private String maskSensitiveFields(String message) {
        String response = message;
        response = response.replaceAll("(?i)\"(" + this.SENSITIVE_DATA + ")\":\"[^\"]*\"", "\"$1\" : \"********\"");
        response = response.replaceAll("(?i)\"(" + this.SENSITIVE_DATA + ")\"\\s*:\\s*\"[^\"]*\"", "\"$1\" : \"********\"");
        response = response.replaceAll("(?i)\"(" + this.SENSITIVE_DATA + ")\"\\s*:\\s*\"([^\"]*)\"\\s*(,|$)", "\"$1\" : \"********\"$3");
        response = response.replaceAll("(?i)(" + this.SENSITIVE_DATA + "):\\s*\\S*", "$1: ********");
        response = response.replaceAll("(?i)(" + this.SENSITIVE_DATA + "):\\s*.*", "$1: ********");
        response = response.replaceAll("(?i)(" + this.SENSITIVE_DATA + "):\\s*\\S+", "$1: ********");
        return response;
    }

    private Object[] filterSensitiveFields(Object ... objects) {
        ArrayList<Object> clonedObjects = new ArrayList<Object>();
        for (Object object : objects) {
            if (object != null && !this.isJavaBaseClass(object.getClass())) {
                clonedObjects.add(this.cloneAndFilterFields(object));
                continue;
            }
            if (object instanceof String) {
                clonedObjects.add(this.maskSensitiveFields((String)object));
                continue;
            }
            clonedObjects.add(object);
        }
        return clonedObjects.toArray();
    }

    private boolean isJavaBaseClass(Class<?> clazz) {
        return !ObjectUtils.isEmpty((Object)clazz.getModule().getName()) && clazz.getModule().getName().equals("java.base");
    }

    private Object cloneAndFilterFields(Object originalObject) {
        if (originalObject instanceof String) {
            return this.maskSensitiveFields((String)originalObject);
        }
        try {
            Class<?> clazz = originalObject.getClass();
            Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            Object clonedObject = constructor.newInstance(new Object[0]);
            for (Field field : originalObject.getClass().getDeclaredFields()) {
                String fieldName;
                field.setAccessible(true);
                Object fieldValue = field.get(originalObject);
                if (fieldValue instanceof String && this.isSensitiveField(fieldName = field.getName())) {
                    fieldValue = "********";
                }
                field.set(clonedObject, fieldValue);
            }
            return clonedObject;
        }
        catch (Exception e) {
            return originalObject;
        }
    }

    private boolean isSensitiveField(String fieldName) {
        return fieldName.matches("(?i)(" + this.SENSITIVE_DATA + ")");
    }

    public String getName() {
        return this.logger.getName();
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public void info(String s) {
        this.logger.info(this.maskSensitiveFields(s));
    }

    public void info(String s, Object o) {
        this.logger.info(this.maskSensitiveFields(s), this.filterSensitiveFields(o));
    }

    public void info(String s, Object o, Object o1) {
        this.logger.info(this.maskSensitiveFields(s), (Object)this.filterSensitiveFields(o), (Object)this.filterSensitiveFields(o1));
    }

    public void info(String s, Object ... objects) {
        this.logger.info(this.maskSensitiveFields(s), this.filterSensitiveFields(objects));
    }

    public void info(String s, Throwable throwable) {
        this.logger.info(this.maskSensitiveFields(s), throwable);
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.logger.isInfoEnabled(marker);
    }

    public void info(Marker marker, String s) {
        this.logger.info(marker, this.maskSensitiveFields(s));
    }

    public void info(Marker marker, String s, Object o) {
        this.logger.info(marker, this.maskSensitiveFields(s), this.filterSensitiveFields(o));
    }

    public void info(Marker marker, String s, Object o, Object o1) {
        this.logger.info(marker, this.maskSensitiveFields(s), (Object)this.filterSensitiveFields(o), (Object)this.filterSensitiveFields(o1));
    }

    public void info(Marker marker, String s, Object ... objects) {
        this.logger.info(marker, this.maskSensitiveFields(s), this.filterSensitiveFields(objects));
    }

    public void info(Marker marker, String s, Throwable throwable) {
        this.logger.info(marker, this.maskSensitiveFields(s), throwable);
    }

    public boolean isWarnEnabled() {
        return false;
    }

    public void trace(String s) {
        this.logger.trace(this.maskSensitiveFields(s));
    }

    public void trace(String s, Object o) {
        this.logger.trace(this.maskSensitiveFields(s), this.filterSensitiveFields(o));
    }

    public void trace(String s, Object o, Object o1) {
        this.logger.trace(this.maskSensitiveFields(s), (Object)this.filterSensitiveFields(o), (Object)this.filterSensitiveFields(o1));
    }

    public void trace(String s, Object ... objects) {
        this.logger.trace(this.maskSensitiveFields(s), this.filterSensitiveFields(objects));
    }

    public void trace(String s, Throwable throwable) {
        this.logger.trace(this.maskSensitiveFields(s), throwable);
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.logger.isTraceEnabled(marker);
    }

    public void trace(Marker marker, String s) {
        this.logger.trace(marker, this.maskSensitiveFields(s));
    }

    public void trace(Marker marker, String s, Object o) {
        this.logger.trace(marker, this.maskSensitiveFields(s), this.filterSensitiveFields(o));
    }

    public void trace(Marker marker, String s, Object o, Object o1) {
        this.logger.trace(marker, this.maskSensitiveFields(s), (Object)this.filterSensitiveFields(o), (Object)this.filterSensitiveFields(o1));
    }

    public void trace(Marker marker, String s, Object ... objects) {
        this.logger.trace(marker, this.maskSensitiveFields(s), this.filterSensitiveFields(objects));
    }

    public void trace(Marker marker, String s, Throwable throwable) {
        this.logger.trace(marker, this.maskSensitiveFields(s), throwable);
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public void debug(String s) {
        this.logger.debug(this.maskSensitiveFields(s));
    }

    public void debug(String s, Object o) {
        this.logger.debug(this.maskSensitiveFields(s), this.filterSensitiveFields(o));
    }

    public void debug(String s, Object o, Object o1) {
        this.logger.debug(this.maskSensitiveFields(s), (Object)this.filterSensitiveFields(o), (Object)this.filterSensitiveFields(o1));
    }

    public void debug(String s, Object ... objects) {
        this.logger.debug(this.maskSensitiveFields(s), this.filterSensitiveFields(objects));
    }

    public void debug(String s, Throwable throwable) {
        this.logger.debug(this.maskSensitiveFields(s), throwable);
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.logger.isDebugEnabled(marker);
    }

    public void debug(Marker marker, String s) {
        this.logger.debug(marker, this.maskSensitiveFields(s));
    }

    public void debug(Marker marker, String s, Object o) {
        this.logger.debug(marker, this.maskSensitiveFields(s), this.filterSensitiveFields(o));
    }

    public void debug(Marker marker, String s, Object o, Object o1) {
        this.logger.debug(marker, this.maskSensitiveFields(s), (Object)this.filterSensitiveFields(o), (Object)this.filterSensitiveFields(o1));
    }

    public void debug(Marker marker, String s, Object ... objects) {
        this.logger.debug(marker, this.maskSensitiveFields(s), this.filterSensitiveFields(objects));
    }

    public void debug(Marker marker, String s, Throwable throwable) {
        this.logger.debug(marker, this.maskSensitiveFields(s), throwable);
    }

    public boolean isInfoEnabled() {
        return false;
    }

    public void error(String s) {
        this.logger.error(this.maskSensitiveFields(s));
    }

    public void error(String s, Object o) {
        this.logger.error(this.maskSensitiveFields(s), this.filterSensitiveFields(o));
    }

    public void error(String s, Object o, Object o1) {
        this.logger.error(this.maskSensitiveFields(s), (Object)this.filterSensitiveFields(o), (Object)this.filterSensitiveFields(o1));
    }

    public void error(String s, Object ... objects) {
        this.logger.error(this.maskSensitiveFields(s), this.filterSensitiveFields(objects));
    }

    public void error(String s, Throwable throwable) {
        this.logger.error(this.maskSensitiveFields(s), throwable);
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.logger.isErrorEnabled(marker);
    }

    public void error(Marker marker, String s) {
        this.logger.error(marker, this.maskSensitiveFields(s));
    }

    public void error(Marker marker, String s, Object o) {
        this.logger.error(marker, this.maskSensitiveFields(s), this.filterSensitiveFields(o));
    }

    public void error(Marker marker, String s, Object o, Object o1) {
        this.logger.error(marker, this.maskSensitiveFields(s), (Object)this.filterSensitiveFields(o), (Object)this.filterSensitiveFields(o1));
    }

    public void error(Marker marker, String s, Object ... objects) {
        this.logger.error(marker, this.maskSensitiveFields(s), this.filterSensitiveFields(objects));
    }

    public void error(Marker marker, String s, Throwable throwable) {
        this.logger.error(marker, this.maskSensitiveFields(s), throwable);
    }

    public void warn(String s) {
        this.logger.warn(this.maskSensitiveFields(s));
    }

    public void warn(String s, Object o) {
        this.logger.warn(this.maskSensitiveFields(s), this.filterSensitiveFields(o));
    }

    public void warn(String s, Object o, Object o1) {
        this.logger.warn(this.maskSensitiveFields(s), (Object)this.filterSensitiveFields(o), (Object)this.filterSensitiveFields(o1));
    }

    public void warn(String s, Object ... objects) {
        this.logger.warn(this.maskSensitiveFields(s), this.filterSensitiveFields(objects));
    }

    public void warn(String s, Throwable throwable) {
        this.logger.warn(this.maskSensitiveFields(s), throwable);
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.logger.isWarnEnabled(marker);
    }

    public void warn(Marker marker, String s) {
        this.logger.warn(marker, this.maskSensitiveFields(s));
    }

    public void warn(Marker marker, String s, Object o) {
        this.logger.warn(marker, this.maskSensitiveFields(s), this.filterSensitiveFields(o));
    }

    public void warn(Marker marker, String s, Object o, Object o1) {
        this.logger.warn(marker, this.maskSensitiveFields(s), (Object)this.filterSensitiveFields(o), (Object)this.filterSensitiveFields(o1));
    }

    public void warn(Marker marker, String s, Object ... objects) {
        this.logger.warn(marker, this.maskSensitiveFields(s), this.filterSensitiveFields(objects));
    }

    public void warn(Marker marker, String s, Throwable throwable) {
        this.logger.warn(marker, this.maskSensitiveFields(s), throwable);
    }

    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }
}

