/*
 * Decompiled with CFR 0.152.
 */
package io.github.giovannilamarmora.utils.web;

import io.github.giovannilamarmora.utils.interceptors.LogInterceptor;
import io.github.giovannilamarmora.utils.interceptors.LogTimeTracker;
import io.github.giovannilamarmora.utils.logger.LoggerFilter;
import org.slf4j.Logger;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.ObjectUtils;

public interface HeaderManager {
    public static final Logger LOG = LoggerFilter.getLogger(HeaderManager.class);

    @LogInterceptor(type=LogTimeTracker.ActionType.UTILS_LOGGER)
    public static void setHeaderInResponse(String headerName, String headerValue, ServerHttpResponse response) {
        if (ObjectUtils.isEmpty((Object)headerValue)) {
            return;
        }
        response.getHeaders().set(headerName, headerValue);
    }

    @LogInterceptor(type=LogTimeTracker.ActionType.UTILS_LOGGER)
    public static void addHeaderInResponse(String headerName, String headerValue, ServerHttpResponse response) {
        if (ObjectUtils.isEmpty((Object)headerValue)) {
            return;
        }
        response.getHeaders().add(headerName, headerValue);
    }

    @LogInterceptor(type=LogTimeTracker.ActionType.UTILS_LOGGER)
    public static void addOrSetHeaderInResponse(String headerName, String headerValue, ServerHttpResponse response) {
        if (ObjectUtils.isEmpty((Object)headerValue)) {
            return;
        }
        if (response.getHeaders().containsKey((Object)headerName)) {
            HeaderManager.setHeaderInResponse(headerName, headerValue, response);
        } else {
            HeaderManager.addHeaderInResponse(headerName, headerValue, response);
        }
    }

    @LogInterceptor(type=LogTimeTracker.ActionType.UTILS_LOGGER)
    public static String getHeader(String headerName, ServerHttpRequest request) {
        return !ObjectUtils.isEmpty((Object)headerName) && !ObjectUtils.isEmpty((Object)request.getHeaders().getFirst(headerName)) ? request.getHeaders().getFirst(headerName) : null;
    }
}

