/*
 * Decompiled with CFR 0.152.
 */
package io.github.giovannilamarmora.utils.web;

import io.github.giovannilamarmora.utils.interceptors.LogInterceptor;
import io.github.giovannilamarmora.utils.interceptors.LogTimeTracker;
import io.github.giovannilamarmora.utils.interceptors.Logged;
import io.github.giovannilamarmora.utils.logger.LoggerFilter;
import io.github.giovannilamarmora.utils.utilities.Mapper;
import io.github.giovannilamarmora.utils.utilities.ObjectToolkit;
import java.net.InetAddress;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.text.StringTokenizer;
import org.slf4j.Logger;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.PatternMatchUtils;
import org.springframework.web.util.UriBuilder;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriUtils;

@Service
@Logged
public interface WebManager {
    public static final Logger LOG = LoggerFilter.getLogger(WebManager.class);
    public static final String CLIENT_IP = "Client-IP";
    public static final String X_FORWARDED_FOR = "X-Forwarded-For";
    public static final String X_ORIGINAL_FORWARDED_FOR = "x-original-forwarded-for";

    @LogInterceptor(type=LogTimeTracker.ActionType.UTILS_LOGGER)
    public static String getAddressFromRequest(ServerHttpRequest request) {
        List host = request.getHeaders().get((Object)"Referer");
        if (ObjectUtils.isEmpty((Object)host)) {
            return WebManager.getRealClientIP(request);
        }
        HashMap<String, Object> requestData = new HashMap<String, Object>();
        requestData.put("ingress_host", host);
        requestData.put("ip_address", WebManager.getRealClientIP(request));
        return Mapper.writeObjectToString(requestData);
    }

    @LogInterceptor(type=LogTimeTracker.ActionType.UTILS_LOGGER)
    public static String getHostFromRequest(ServerHttpRequest request) {
        List host = request.getHeaders().get((Object)"Referer");
        return Mapper.writeObjectToString(host);
    }

    @LogInterceptor(type=LogTimeTracker.ActionType.UTILS_LOGGER)
    public static String getRealClientIP(ServerHttpRequest request) {
        LOG.debug("Getting Real Client IP for {}", (Object)request.getPath().value());
        String ipClient = null;
        String headerClientIp = request.getHeaders().getFirst(CLIENT_IP);
        String headerXForwardedFor = request.getHeaders().getFirst(X_FORWARDED_FOR);
        String headerOriginalXForwardedFor = request.getHeaders().getFirst(X_ORIGINAL_FORWARDED_FOR);
        LOG.debug("Info header Client-IP: {}", (Object)headerClientIp);
        LOG.debug("Info header X-Forwarded-For: {}", (Object)headerXForwardedFor);
        LOG.debug("Info header x-original-forwarded-for: {}", (Object)headerOriginalXForwardedFor);
        if (!ObjectToolkit.isNullOrEmpty(headerClientIp)) {
            ipClient = headerClientIp;
        } else if (!ObjectToolkit.isNullOrEmpty(headerXForwardedFor)) {
            ipClient = headerXForwardedFor;
        } else if (!ObjectToolkit.isNullOrEmpty(headerOriginalXForwardedFor)) {
            ipClient = WebManager.getClientIp(request, headerOriginalXForwardedFor);
        }
        if (ObjectToolkit.isNullOrEmpty(ipClient) && !ObjectToolkit.isNullOrEmpty(request.getRemoteAddress())) {
            ipClient = Objects.requireNonNull(request.getRemoteAddress()).getHostName();
        }
        LOG.debug("Ended Get Real Client IP: {}", (Object)ipClient);
        return ipClient;
    }

    @LogInterceptor(type=LogTimeTracker.ActionType.UTILS_LOGGER)
    private static String getClientIp(ServerHttpRequest request, String xForwardedForHeader) {
        LOG.debug("Getting Client IP for {}", (Object)xForwardedForHeader);
        if (xForwardedForHeader == null) {
            return Objects.requireNonNull(request.getRemoteAddress()).getHostName();
        }
        return new StringTokenizer(xForwardedForHeader, ",").nextToken().trim();
    }

    @LogInterceptor(type=LogTimeTracker.ActionType.UTILS_LOGGER)
    public static String getUrlAsString(Function<UriBuilder, URI> urlFunction, String baseUrl) {
        if (ObjectUtils.isEmpty(urlFunction)) {
            return null;
        }
        if (ObjectUtils.isEmpty((Object)baseUrl)) {
            baseUrl = "";
        }
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUri((URI)urlFunction.apply((UriBuilder)UriComponentsBuilder.fromUriString((String)baseUrl)));
        return UriUtils.decode((String)uriComponentsBuilder.build().toUriString(), (Charset)StandardCharsets.UTF_8);
    }

    @LogInterceptor(type=LogTimeTracker.ActionType.UTILS_LOGGER)
    public static String getRemoteAddress(ServerHttpRequest request) {
        String hostHeader = request.getHeaders().getFirst("Host");
        if (!ObjectToolkit.isNullOrEmpty(hostHeader)) {
            return hostHeader;
        }
        String clientIp = WebManager.getRealClientIP(request);
        if (ObjectToolkit.isNullOrEmpty(clientIp)) {
            if (!ObjectToolkit.isNullOrEmpty(request.getRemoteAddress())) {
                clientIp = request.getRemoteAddress().getHostName();
            } else {
                return null;
            }
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(clientIp);
            if (!ObjectToolkit.isNullOrEmpty(inetAddress.getHostName())) {
                return inetAddress.getHostName();
            }
        }
        catch (Exception e) {
            if (!ObjectToolkit.isNullOrEmpty(request.getRemoteAddress())) {
                return request.getRemoteAddress().getHostName();
            }
            return null;
        }
        return clientIp;
    }

    @LogInterceptor(type=LogTimeTracker.ActionType.UTILS_LOGGER)
    public static boolean shouldNotFilter(ServerHttpRequest req, List<String> shouldNotFilter) {
        String path = req.getPath().value();
        String method = req.getMethod().name();
        if (HttpMethod.OPTIONS.name().equals(method)) {
            return true;
        }
        return shouldNotFilter.stream().anyMatch(endpoint -> PatternMatchUtils.simpleMatch((String)endpoint, (String)path));
    }

    @LogInterceptor(type=LogTimeTracker.ActionType.UTILS_LOGGER)
    public static boolean shouldFilter(ServerHttpRequest req, List<String> shouldFilter) {
        String path = req.getPath().value();
        String method = req.getMethod().name();
        if (HttpMethod.OPTIONS.name().equals(method)) {
            return false;
        }
        return shouldFilter.stream().anyMatch(endpoint -> PatternMatchUtils.simpleMatch((String)endpoint, (String)path));
    }

    @LogInterceptor(type=LogTimeTracker.ActionType.UTILS_LOGGER)
    public static String encodeURLValue(String value) {
        return ObjectUtils.isEmpty((Object)value) ? value : URLEncoder.encode(value, StandardCharsets.UTF_8);
    }

    @LogInterceptor(type=LogTimeTracker.ActionType.UTILS_LOGGER)
    public static String decodeURLValue(String value) {
        return ObjectUtils.isEmpty((Object)value) ? value : URLDecoder.decode(value, StandardCharsets.UTF_8);
    }
}

