/*
 * Decompiled with CFR 0.152.
 */
package io.github.giovannilamarmora.utils.webClient;

import java.net.URI;
import java.util.Map;
import java.util.function.Function;
import lombok.Generated;
import org.springframework.web.util.UriBuilder;

public class UtilsUriBuilder {
    private Function<UriBuilder, URI> uri;
    private String stringUri;

    public Function<UriBuilder, URI> get() {
        return this.uri;
    }

    public static UtilsUriBuilder toBuild() {
        return new UtilsUriBuilder();
    }

    public UtilsUriBuilder set(String path, Map<String, Object> queryParams) {
        StringBuilder pathBuilder = new StringBuilder(path);
        if (queryParams != null) {
            for (String key : queryParams.keySet()) {
                if (pathBuilder.toString().contains("{" + key + "}")) {
                    pathBuilder = new StringBuilder(pathBuilder.toString().replace("{" + key + "}", queryParams.get(key).toString()));
                    continue;
                }
                if (pathBuilder.toString().contains(":" + key)) {
                    pathBuilder = new StringBuilder(pathBuilder.toString().replace(":" + key, queryParams.get(key).toString()));
                    continue;
                }
                if (!pathBuilder.toString().contains("?")) {
                    pathBuilder.append("?");
                } else {
                    pathBuilder.append("&");
                }
                pathBuilder.append(key).append("=").append(queryParams.get(key));
            }
        }
        this.stringUri = pathBuilder.toString();
        return this;
    }

    public static Function<UriBuilder, URI> buildUri(String url, Map<String, Object> param) {
        return uriBuilder -> {
            UriBuilder builder = uriBuilder.path(url);
            if (param != null && !param.isEmpty()) {
                for (Map.Entry entry : param.entrySet()) {
                    builder.queryParam((String)entry.getKey(), new Object[]{entry.getValue()});
                }
            }
            return builder.build(new Object[0]);
        };
    }

    @Generated
    public String getStringUri() {
        return this.stringUri;
    }
}

