/*
 * Decompiled with CFR 0.152.
 */
package io.github.gitbucket.solidbase.manager;

import io.github.gitbucket.solidbase.manager.VersionManager;
import io.github.gitbucket.solidbase.migration.MigrationUtils;
import java.sql.Connection;
import java.sql.ResultSet;

public class JDBCVersionManager
implements VersionManager {
    private final Connection conn;

    public JDBCVersionManager(Connection conn) {
        this.conn = conn;
    }

    @Override
    public void initialize() throws Exception {
        if (!this.checkTableExist()) {
            MigrationUtils.updateDatabase(this.conn, "CREATE TABLE VERSIONS (MODULE_ID VARCHAR(100) NOT NULL PRIMARY KEY, VERSION VARCHAR(100) NOT NULL)", new Object[0]);
        }
    }

    @Override
    public void updateVersion(String moduleId, String version) throws Exception {
        if (MigrationUtils.updateDatabase(this.conn, "UPDATE VERSIONS SET VERSION = ? WHERE MODULE_ID = ?", version, moduleId) == 0) {
            MigrationUtils.updateDatabase(this.conn, "INSERT INTO VERSIONS (MODULE_ID, VERSION) VALUES (?, ?)", moduleId, version);
        }
    }

    @Override
    public String getCurrentVersion(String moduleId) throws Exception {
        return MigrationUtils.selectStringFromDatabase(this.conn, "SELECT VERSION FROM VERSIONS WHERE MODULE_ID = ?", moduleId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean checkTableExist() {
        try (ResultSet rs = this.conn.getMetaData().getTables(null, null, "%", new String[]{"TABLE"});){
            String tableName;
            do {
                if (!rs.next()) return false;
            } while (!(tableName = rs.getString("TABLE_NAME")).toUpperCase().equals("VERSIONS"));
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

