/*
 * Decompiled with CFR 0.152.
 */
package io.github.gitbucket.solidbase.migration;

import io.github.gitbucket.solidbase.Solidbase;
import io.github.gitbucket.solidbase.migration.Migration;
import io.github.gitbucket.solidbase.migration.MigrationUtils;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;

public class AntMigration
implements Migration {
    private final String path;

    public AntMigration() {
        this(null);
    }

    public AntMigration(String path) {
        this.path = path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void migrate(String moduleId, String version, Map<String, Object> context) throws Exception {
        String path = this.path;
        if (path == null) {
            path = moduleId + "_" + version + ".xml";
        }
        Path tempFilePath = Files.createTempFile("solidbase_ant-", ".xml", new FileAttribute[0]);
        try {
            ClassLoader classLoader = (ClassLoader)context.get(Solidbase.CLASSLOADER);
            String source = MigrationUtils.readResourceAsString(classLoader, path);
            Files.write(tempFilePath, source.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            Project project = new Project();
            project.setProperty("ant.file", path);
            project.init();
            ProjectHelper helper = ProjectHelper.getProjectHelper();
            project.addReference("ant.projectHelper", (Object)helper);
            helper.parse(project, (Object)tempFilePath.toFile());
            System.out.println(project.getDefaultTarget());
            project.executeTarget(project.getDefaultTarget());
        }
        finally {
            MigrationUtils.ignoreException(() -> Files.delete(tempFilePath));
        }
    }
}

