/*
 * Decompiled with CFR 0.152.
 */
package io.github.gitbucket.solidbase.migration;

import io.github.gitbucket.solidbase.Solidbase;
import io.github.gitbucket.solidbase.migration.LiquibaseXmlPreProcessor;
import io.github.gitbucket.solidbase.migration.Migration;
import io.github.gitbucket.solidbase.migration.MigrationUtils;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import liquibase.Liquibase;
import liquibase.change.Change;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.database.Database;
import liquibase.resource.AbstractResource;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.Resource;
import liquibase.resource.ResourceAccessor;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.statement.SqlStatement;

public class LiquibaseMigration
implements Migration {
    private final String path;

    public LiquibaseMigration() {
        this(null);
    }

    public LiquibaseMigration(String path) {
        this.path = path;
    }

    @Override
    public void migrate(String moduleId, String version, Map<String, Object> context) throws Exception {
        Connection conn = (Connection)context.get(Solidbase.CONNECTION);
        ClassLoader cl = (ClassLoader)context.get(Solidbase.CLASSLOADER);
        Database db = (Database)context.get(Solidbase.DATABASE);
        this.migrate(conn, db, cl, moduleId, version, context);
    }

    protected void migrate(Connection conn, Database database, ClassLoader classLoader, String moduleId, String version, Map<String, Object> context) throws Exception {
        ArrayList<String> fileNames = new ArrayList<String>();
        if (this.path != null) {
            if (this.path.endsWith(".xml")) {
                fileNames.add(this.path.replaceFirst("\\.xml$", "_" + database.getShortName() + ".xml"));
            }
            fileNames.add(this.path);
        }
        fileNames.add(moduleId + "_" + version + "_" + database.getShortName() + ".xml");
        fileNames.add(moduleId + "_" + version + ".xml");
        String path = null;
        String source = null;
        for (String fileName : fileNames) {
            source = MigrationUtils.readResourceAsString(classLoader, fileName);
            if (source == null) continue;
            path = fileName;
            break;
        }
        Liquibase liquibase = new Liquibase(path, (ResourceAccessor)new StringResourceAccessor(path, new LiquibaseXmlPreProcessor().preProcess(moduleId, version, source), classLoader), database);
        ChangeLogParameters params = liquibase.getChangeLogParameters();
        params.set("currentDateTime", (Object)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(new Date()));
        DatabaseChangeLog changeLogs = liquibase.getDatabaseChangeLog();
        List changeSets = changeLogs.getChangeSets();
        for (ChangeSet changeSet : changeSets) {
            for (Change change : changeSet.getChanges()) {
                Sql[] sqls;
                SqlStatement[] statements = change.generateStatements(database);
                for (Sql sql : sqls = SqlGeneratorFactory.getInstance().generateSql(statements, database)) {
                    MigrationUtils.updateDatabase(conn, sql.toSql(), new Object[0]);
                }
            }
        }
    }

    private static class ByteArrayResource
    extends AbstractResource {
        private final String source;

        public ByteArrayResource(String source, String path, URI uri) {
            super(path, uri);
            this.source = source;
        }

        public InputStream openInputStream() throws IOException {
            return new ByteArrayInputStream(this.source.getBytes(StandardCharsets.UTF_8));
        }

        public boolean exists() {
            return true;
        }

        public Resource resolve(String other) {
            return null;
        }

        public Resource resolveSibling(String other) {
            return null;
        }
    }

    private static class StringResourceAccessor
    extends ClassLoaderResourceAccessor {
        private final String fileName;
        private final String source;
        private final ClassLoader classLoader;

        public StringResourceAccessor(String fileName, String source, ClassLoader classLoader) {
            super(classLoader);
            this.fileName = fileName;
            this.source = source;
            this.classLoader = classLoader;
        }

        public List<Resource> getAll(String path) throws IOException {
            if (path.equals(this.fileName)) {
                ArrayList<Resource> returnList = new ArrayList<Resource>();
                try {
                    URI uri = this.classLoader.getResources(path).nextElement().toURI();
                    returnList.add((Resource)new ByteArrayResource(this.source, path, uri));
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
                return returnList;
            }
            throw new FileNotFoundException(path);
        }
    }
}

