/*
 * Decompiled with CFR 0.152.
 */
package io.github.gitbucket.solidbase.migration;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class MigrationUtils {
    public static int updateDatabase(Connection conn, String sql, Object ... params) throws SQLException {
        try (PreparedStatement stmt = conn.prepareStatement(sql);){
            MigrationUtils.setParameters(stmt, params);
            int n = stmt.executeUpdate();
            return n;
        }
    }

    public static Integer selectIntFromDatabase(Connection conn, String sql, Object ... params) throws SQLException {
        try (PreparedStatement stmt = conn.prepareStatement(sql);){
            Integer n;
            block16: {
                ResultSet rs;
                block14: {
                    Integer n2;
                    block15: {
                        MigrationUtils.setParameters(stmt, params);
                        rs = stmt.executeQuery();
                        try {
                            if (!rs.next()) break block14;
                            n2 = rs.getInt(1);
                            if (rs == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return n2;
                }
                n = null;
                if (rs == null) break block16;
                rs.close();
            }
            return n;
        }
    }

    public static String selectStringFromDatabase(Connection conn, String sql, Object ... params) throws SQLException {
        try (PreparedStatement stmt = conn.prepareStatement(sql);){
            String string;
            block16: {
                ResultSet rs;
                block14: {
                    String string2;
                    block15: {
                        MigrationUtils.setParameters(stmt, params);
                        rs = stmt.executeQuery();
                        try {
                            if (!rs.next()) break block14;
                            string2 = rs.getString(1);
                            if (rs == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return string2;
                }
                string = null;
                if (rs == null) break block16;
                rs.close();
            }
            return string;
        }
    }

    private static void setParameters(PreparedStatement stmt, Object ... params) throws SQLException {
        for (int i = 0; i < params.length; ++i) {
            Object param = params[i];
            if (param instanceof Integer) {
                stmt.setInt(i + 1, (Integer)param);
                continue;
            }
            if (!(param instanceof String)) continue;
            stmt.setString(i + 1, (String)param);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readStreamAsString(InputStream in) throws IOException {
        if (in == null) {
            return null;
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buf = new byte[8192];
            int length = 0;
            while ((length = in.read(buf)) != -1) {
                out.write(buf, 0, length);
            }
            String string = out.toString("UTF-8");
            return string;
        }
        finally {
            in.close();
        }
    }

    public static String readResourceAsString(ClassLoader cl, String path) throws IOException {
        return MigrationUtils.readStreamAsString(cl.getResourceAsStream(path));
    }

    public static void ignoreException(ThrowableRunnable f) {
        try {
            f.run();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static interface ThrowableRunnable {
        public void run() throws Exception;
    }
}

