/*
 * Decompiled with CFR 0.152.
 */
package io.github.gitbucket.solidbase.migration;

import io.github.gitbucket.solidbase.Solidbase;
import io.github.gitbucket.solidbase.migration.Migration;
import io.github.gitbucket.solidbase.migration.MigrationUtils;
import java.io.FileNotFoundException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import liquibase.database.Database;

public class SqlMigration
implements Migration {
    private final String path;

    public SqlMigration() {
        this(null);
    }

    public SqlMigration(String path) {
        this.path = path;
    }

    @Override
    public void migrate(String moduleId, String version, Map<String, Object> context) throws Exception {
        Connection conn = (Connection)context.get(Solidbase.CONNECTION);
        ClassLoader cl = (ClassLoader)context.get(Solidbase.CLASSLOADER);
        Database db = (Database)context.get(Solidbase.DATABASE);
        this.migrate(conn, db, cl, moduleId, version, context);
    }

    protected void migrate(Connection conn, Database database, ClassLoader classLoader, String moduleId, String version, Map<String, Object> context) throws Exception {
        String fileName;
        ArrayList<String> fileNames = new ArrayList<String>();
        if (this.path != null) {
            if (this.path.endsWith(".sql")) {
                fileNames.add(this.path.replaceFirst("\\.sql$", "_" + database.getShortName() + ".sql"));
            }
            fileNames.add(this.path);
        }
        fileNames.add(moduleId + "_" + version + "_" + database.getShortName() + ".sql");
        fileNames.add(moduleId + "_" + version + ".sql");
        String sql = null;
        Iterator<Object> iterator = fileNames.iterator();
        while (iterator.hasNext() && (sql = MigrationUtils.readResourceAsString(classLoader, fileName = (String)iterator.next())) == null) {
        }
        if (sql == null) {
            throw new FileNotFoundException((String)fileNames.get(fileNames.size() - 1));
        }
        for (String singleSql : this.splitMultiStatementSql(sql)) {
            MigrationUtils.updateDatabase(conn, singleSql, new Object[0]);
        }
    }

    protected List<String> splitMultiStatementSql(String sql) {
        ArrayList<String> result = new ArrayList<String>();
        boolean stringLiteral = false;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < sql.length(); ++i) {
            char c = sql.charAt(i);
            if (c == '\'') {
                boolean bl = stringLiteral = !stringLiteral;
            }
            if (c == ';' && !stringLiteral) {
                String stmt = sb.toString().trim();
                if (stmt.length() > 0) {
                    result.add(stmt);
                }
                sb.setLength(0);
                continue;
            }
            sb.append(c);
        }
        String stmt = sb.toString().trim();
        if (stmt.length() > 0) {
            result.add(stmt);
        }
        return result;
    }
}

