/*
 * Decompiled with CFR 0.152.
 */
package io.github.givimad.rustpotter_java;

import io.github.givimad.rustpotter_java.InternalPointerMarker;
import io.github.givimad.rustpotter_java.JNIReachabilityFence;
import io.github.givimad.rustpotter_java.NativeUtils;
import io.github.givimad.rustpotter_java.RustpotterConfig;
import io.github.givimad.rustpotter_java.RustpotterDetection;
import java.io.IOException;
import java.util.Optional;

public final class Rustpotter {
    long mNativeObj;
    private static boolean libraryLoaded = false;

    public Rustpotter(RustpotterConfig config) throws Exception {
        long a0 = config.mNativeObj;
        this.mNativeObj = Rustpotter.init(a0);
        JNIReachabilityFence.reachabilityFence1(config);
    }

    private static native long init(long var0) throws Exception;

    public final Optional<RustpotterDetection> processSort(short[] samples) {
        long ret = Rustpotter.do_processSort(this.mNativeObj, samples);
        Optional<RustpotterDetection> convRet = ret != 0L ? Optional.of(new RustpotterDetection(InternalPointerMarker.RAW_PTR, ret)) : Optional.empty();
        return convRet;
    }

    private static native long do_processSort(long var0, short[] var2);

    public final Optional<RustpotterDetection> processInt(int[] samples) {
        long ret = Rustpotter.do_processInt(this.mNativeObj, samples);
        Optional<RustpotterDetection> convRet = ret != 0L ? Optional.of(new RustpotterDetection(InternalPointerMarker.RAW_PTR, ret)) : Optional.empty();
        return convRet;
    }

    private static native long do_processInt(long var0, int[] var2);

    public final Optional<RustpotterDetection> processFloat(float[] samples) {
        long ret = Rustpotter.do_processFloat(this.mNativeObj, samples);
        Optional<RustpotterDetection> convRet = ret != 0L ? Optional.of(new RustpotterDetection(InternalPointerMarker.RAW_PTR, ret)) : Optional.empty();
        return convRet;
    }

    private static native long do_processFloat(long var0, float[] var2);

    public final Optional<RustpotterDetection> processBytes(byte[] bytes) {
        long ret = Rustpotter.do_processBytes(this.mNativeObj, bytes);
        Optional<RustpotterDetection> convRet = ret != 0L ? Optional.of(new RustpotterDetection(InternalPointerMarker.RAW_PTR, ret)) : Optional.empty();
        return convRet;
    }

    private static native long do_processBytes(long var0, byte[] var2);

    public final void addWakewordFile(String key, String path) throws Exception {
        Rustpotter.do_addWakewordFile(this.mNativeObj, key, path);
    }

    private static native void do_addWakewordFile(long var0, String var2, String var3) throws Exception;

    public final void addWakewordBytes(String key, byte[] bytes) throws Exception {
        Rustpotter.do_addWakewordBytes(this.mNativeObj, key, bytes);
    }

    private static native void do_addWakewordBytes(long var0, String var2, byte[] var3) throws Exception;

    public final boolean removeWakeword(String key) {
        boolean ret = Rustpotter.do_removeWakeword(this.mNativeObj, key);
        return ret;
    }

    private static native boolean do_removeWakeword(long var0, String var2);

    public final boolean removeWakewords() {
        boolean ret = Rustpotter.do_removeWakewords(this.mNativeObj);
        return ret;
    }

    private static native boolean do_removeWakewords(long var0);

    public final long getSamplesPerFrame() {
        long ret = Rustpotter.do_getSamplesPerFrame(this.mNativeObj);
        return ret;
    }

    private static native long do_getSamplesPerFrame(long var0);

    public final long getBytesPerFrame() {
        long ret = Rustpotter.do_getBytesPerFrame(this.mNativeObj);
        return ret;
    }

    private static native long do_getBytesPerFrame(long var0);

    public final void updateConfig(RustpotterConfig config) {
        long a0 = config.mNativeObj;
        Rustpotter.do_updateConfig(this.mNativeObj, a0);
        JNIReachabilityFence.reachabilityFence1(config);
    }

    private static native void do_updateConfig(long var0, long var2);

    public final void reset() {
        Rustpotter.do_reset(this.mNativeObj);
    }

    private static native void do_reset(long var0);

    public synchronized void delete() {
        if (this.mNativeObj != 0L) {
            Rustpotter.do_delete(this.mNativeObj);
            this.mNativeObj = 0L;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.delete();
        }
        finally {
            super.finalize();
        }
    }

    private static native void do_delete(long var0);

    Rustpotter(InternalPointerMarker marker, long ptr) {
        assert (marker == InternalPointerMarker.RAW_PTR);
        this.mNativeObj = ptr;
    }

    public static void loadLibrary() throws IOException {
        if (libraryLoaded) {
            return;
        }
        String bundleLibraryPath = null;
        String osName = System.getProperty("os.name").toLowerCase();
        String osArch = System.getProperty("os.arch").toLowerCase();
        if (osName.contains("win")) {
            if (osArch.contains("amd64") || osArch.contains("x86_64")) {
                bundleLibraryPath = "/librustpotter_java_win_x86_64.dll";
            }
        } else if (osName.contains("nix") || osName.contains("nux") || osName.contains("aix")) {
            if (osArch.contains("amd64") || osArch.contains("x86_64")) {
                bundleLibraryPath = "/librustpotter_java_debian_x86_64.so";
            } else if (osArch.contains("aarch64") || osArch.contains("arm64")) {
                bundleLibraryPath = "/librustpotter_java_debian_aarch64.so";
            } else if (osArch.contains("armv7") || osArch.contains("arm")) {
                bundleLibraryPath = "/librustpotter_java_debian_armv7l.so";
            }
        } else if (osName.contains("mac") || osName.contains("darwin")) {
            if (osArch.contains("amd64") || osArch.contains("x86_64")) {
                bundleLibraryPath = "/librustpotter_java_macos_x86_64.dylib";
            } else if (osArch.contains("aarch64") || osArch.contains("arm64")) {
                bundleLibraryPath = "/librustpotter_java_macos_aarch64.dylib";
            }
        }
        if (bundleLibraryPath == null) {
            throw new IOException("Rustpotter: Unsupported platform.");
        }
        NativeUtils.loadLibraryFromJar(bundleLibraryPath);
        libraryLoaded = true;
    }
}

