/*
 * Decompiled with CFR 0.152.
 */
package io.github.givimad.whisperjni;

import io.github.givimad.whisperjni.WhisperContext;
import io.github.givimad.whisperjni.WhisperContextParams;
import io.github.givimad.whisperjni.WhisperFullParams;
import io.github.givimad.whisperjni.WhisperGrammar;
import io.github.givimad.whisperjni.WhisperState;
import io.github.givimad.whisperjni.internal.LibraryUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class WhisperJNI {
    private static boolean libraryLoaded;
    private static LibraryLogger libraryLogger;

    private native int init(String var1, WhisperContextParams var2);

    private native int initNoState(String var1, WhisperContextParams var2);

    private native int initState(int var1);

    private native int loadGrammar(String var1);

    private native void initOpenVINOEncoder(int var1, String var2);

    private native boolean isMultilingual(int var1);

    private native int full(int var1, WhisperFullParams var2, float[] var3, int var4);

    private native int fullWithState(int var1, int var2, WhisperFullParams var3, float[] var4, int var5);

    private native int fullNSegments(int var1);

    private native int fullNSegmentsFromState(int var1);

    private native long fullGetSegmentTimestamp0(int var1, int var2);

    private native long fullGetSegmentTimestamp1(int var1, int var2);

    private native String fullGetSegmentText(int var1, int var2);

    private native long fullGetSegmentTimestamp0FromState(int var1, int var2);

    private native long fullGetSegmentTimestamp1FromState(int var1, int var2);

    private native String fullGetSegmentTextFromState(int var1, int var2);

    private native void freeContext(int var1);

    private native void freeState(int var1);

    private native void freeGrammar(int var1);

    private native String printSystemInfo();

    private static native void setLogger(boolean var0);

    public WhisperContext init(Path model) throws IOException {
        return this.init(model, null);
    }

    public WhisperContext init(Path model, WhisperContextParams params) throws IOException {
        int ref;
        WhisperJNI.assertModelExists(model);
        if (params == null) {
            params = new WhisperContextParams();
        }
        if ((ref = this.init(model.toAbsolutePath().toString(), params)) == -1) {
            return null;
        }
        return new WhisperContext(this, ref);
    }

    public WhisperContext initNoState(Path model) throws IOException {
        return this.initNoState(model, null);
    }

    public WhisperContext initNoState(Path model, WhisperContextParams params) throws IOException {
        int ref;
        WhisperJNI.assertModelExists(model);
        if (params == null) {
            params = new WhisperContextParams();
        }
        if ((ref = this.initNoState(model.toAbsolutePath().toString(), params)) == -1) {
            return null;
        }
        return new WhisperContext(this, ref);
    }

    public WhisperState initState(WhisperContext context) {
        WhisperJNIPointer.assertAvailable(context);
        int ref = this.initState(context.ref);
        if (ref == -1) {
            return null;
        }
        return new WhisperState(this, ref, context);
    }

    public WhisperGrammar parseGrammar(Path grammarPath) throws IOException {
        if (!Files.exists(grammarPath, new LinkOption[0]) || Files.isDirectory(grammarPath, new LinkOption[0])) {
            throw new FileNotFoundException("Grammar file not found");
        }
        return this.parseGrammar(Files.readString(grammarPath));
    }

    public WhisperGrammar parseGrammar(String text) throws IOException {
        if (text.isBlank()) {
            throw new IOException("Grammar text is blank");
        }
        int ref = this.loadGrammar(text);
        if (ref == -1) {
            return null;
        }
        return new WhisperGrammar(this, ref, text);
    }

    public void initOpenVINO(WhisperContext context, String device) {
        WhisperJNIPointer.assertAvailable(context);
        this.initOpenVINOEncoder(context.ref, device);
    }

    public boolean isMultilingual(WhisperContext context) {
        WhisperJNIPointer.assertAvailable(context);
        return this.isMultilingual(context.ref);
    }

    public int full(WhisperContext context, WhisperFullParams params, float[] samples, int numSamples) {
        WhisperJNIPointer.assertAvailable(context);
        if (params.grammar != null) {
            WhisperJNIPointer.assertAvailable(params.grammar);
        }
        return this.full(context.ref, params, samples, numSamples);
    }

    public int fullWithState(WhisperContext context, WhisperState state, WhisperFullParams params, float[] samples, int numSamples) {
        WhisperJNIPointer.assertAvailable(context);
        WhisperJNIPointer.assertAvailable(state);
        if (params.grammar != null) {
            WhisperJNIPointer.assertAvailable(params.grammar);
        }
        return this.fullWithState(context.ref, state.ref, params, samples, numSamples);
    }

    public int fullNSegmentsFromState(WhisperState state) {
        WhisperJNIPointer.assertAvailable(state);
        return this.fullNSegmentsFromState(state.ref);
    }

    public int fullNSegments(WhisperContext context) {
        WhisperJNIPointer.assertAvailable(context);
        return this.fullNSegments(context.ref);
    }

    public long fullGetSegmentTimestamp0(WhisperContext context, int index) {
        WhisperJNIPointer.assertAvailable(context);
        return this.fullGetSegmentTimestamp0(context.ref, index);
    }

    public long fullGetSegmentTimestamp1(WhisperContext context, int index) {
        WhisperJNIPointer.assertAvailable(context);
        return this.fullGetSegmentTimestamp1(context.ref, index);
    }

    public String fullGetSegmentText(WhisperContext context, int index) {
        WhisperJNIPointer.assertAvailable(context);
        return this.fullGetSegmentText(context.ref, index);
    }

    public long fullGetSegmentTimestamp0FromState(WhisperState state, int index) {
        WhisperJNIPointer.assertAvailable(state);
        return this.fullGetSegmentTimestamp0FromState(state.ref, index);
    }

    public long fullGetSegmentTimestamp1FromState(WhisperState state, int index) {
        WhisperJNIPointer.assertAvailable(state);
        return this.fullGetSegmentTimestamp1FromState(state.ref, index);
    }

    public String fullGetSegmentTextFromState(WhisperState state, int index) {
        WhisperJNIPointer.assertAvailable(state);
        return this.fullGetSegmentTextFromState(state.ref, index);
    }

    public void free(WhisperContext context) {
        if (context.isReleased()) {
            return;
        }
        this.freeContext(context.ref);
        context.release();
    }

    public void free(WhisperState state) {
        if (state.isReleased()) {
            return;
        }
        this.freeState(state.ref);
        state.release();
    }

    public void free(WhisperGrammar grammar) {
        if (grammar.isReleased()) {
            return;
        }
        this.freeGrammar(grammar.ref);
        grammar.release();
    }

    public String getSystemInfo() {
        return this.printSystemInfo();
    }

    public static void loadLibrary() throws IOException {
        WhisperJNI.loadLibrary(null);
    }

    public static void loadLibrary(LoadOptions options) throws IOException {
        if (libraryLoaded) {
            return;
        }
        if (options == null) {
            options = new LoadOptions();
        }
        if (options.logger == null) {
            options.logger = ignored -> {};
        }
        LibraryUtils.loadLibrary(options);
        libraryLoaded = true;
    }

    public static void setLibraryLogger(LibraryLogger logger) {
        libraryLogger = logger;
        WhisperJNI.setLogger(libraryLogger != null);
    }

    protected static void log(String text) {
        if (libraryLogger != null) {
            libraryLogger.log(text);
        }
    }

    private static void assertModelExists(Path model) throws IOException {
        if (!Files.exists(model, new LinkOption[0]) || Files.isDirectory(model, new LinkOption[0])) {
            throw new IOException("Missing model file: " + model);
        }
    }

    protected static abstract class WhisperJNIPointer
    implements AutoCloseable {
        protected final int ref;
        private boolean released;

        protected static void assertAvailable(WhisperJNIPointer pointer) {
            if (pointer.isReleased()) {
                throw new RuntimeException("Unavailable pointer, object is closed");
            }
        }

        protected WhisperJNIPointer(int ref) {
            this.ref = ref;
        }

        protected boolean isReleased() {
            return this.released;
        }

        protected void release() {
            this.released = true;
        }
    }

    public static class LoadOptions {
        public LibraryLogger logger;
        public Path whisperJNILib;
        public Path whisperLib;
    }

    public static interface LibraryLogger {
        public void log(String var1);
    }
}

