/*
 * Decompiled with CFR 0.152.
 */
package io.github.glytching.junit.extension.exception;

import io.github.glytching.junit.extension.exception.ExpectedException;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.FunctionUtils;

public class ExpectedExceptionExtension
implements TestExecutionExceptionHandler {
    private final Function<Throwable, String> function = Throwable::getMessage;

    public void handleTestExecutionException(ExtensionContext extensionContext, Throwable throwable) throws Throwable {
        Optional optional = AnnotationUtils.findAnnotation((Optional)extensionContext.getTestMethod(), ExpectedException.class);
        if (optional.isPresent()) {
            ExpectedException annotation = (ExpectedException)optional.get();
            if (throwable.getClass() == annotation.type() && FunctionUtils.where(this.function, this.getPredicate(annotation)).test(throwable)) {
                return;
            }
        }
        throw throwable;
    }

    private Predicate<String> getPredicate(ExpectedException annotation) {
        if (this.has(annotation.messageStartsWith())) {
            return s -> s.startsWith(annotation.messageStartsWith());
        }
        if (this.has(annotation.messageContains())) {
            return s -> s.contains(annotation.messageContains());
        }
        return s -> s.equals(annotation.messageIs());
    }

    private boolean has(String incoming) {
        return incoming != null && incoming.length() > 0;
    }
}

