/*
 * Decompiled with CFR 0.152.
 */
package io.github.glytching.junit.extension.folder;

import io.github.glytching.junit.extension.folder.TemporaryFolder;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

public class TemporaryFolderExtension
implements AfterEachCallback,
ParameterResolver {
    private static final String KEY = "temporaryFolder";

    public void afterEach(ExtensionContext extensionContext) {
        TemporaryFolder temporaryFolder = (TemporaryFolder)this.getStore(extensionContext).get((Object)KEY, TemporaryFolder.class);
        if (temporaryFolder != null) {
            try {
                temporaryFolder.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.appliesTo(parameterContext.getParameter().getType());
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.getStore(extensionContext).getOrComputeIfAbsent((Object)KEY, key -> new TemporaryFolder());
    }

    private boolean appliesTo(Class<?> clazz) {
        return clazz == TemporaryFolder.class;
    }

    private ExtensionContext.Store getStore(ExtensionContext extensionContext) {
        return extensionContext.getStore(this.namespace(extensionContext));
    }

    private ExtensionContext.Namespace namespace(ExtensionContext extensionContext) {
        return ExtensionContext.Namespace.create((Object[])new Object[]{this.getClass(), extensionContext});
    }
}

