/*
 * Decompiled with CFR 0.152.
 */
package io.github.glytching.junit.extension.system;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class RestoreContext {
    private final Set<String> propertyNames;
    private final Map<String, String> restoreProperties;

    private RestoreContext(Set<String> propertyNames, Map<String, String> restoreProperties) {
        this.propertyNames = propertyNames;
        this.restoreProperties = restoreProperties;
    }

    public static Builder createBuilder() {
        return new Builder();
    }

    public void restore() {
        for (String propertyName : this.propertyNames) {
            if (this.restoreProperties.containsKey(propertyName)) {
                System.setProperty(propertyName, this.restoreProperties.get(propertyName));
                continue;
            }
            System.clearProperty(propertyName);
        }
    }

    static class Builder {
        private final Set<String> properties = new HashSet<String>();
        private final Map<String, String> restoreProperties = new HashMap<String, String>();

        private Builder() {
        }

        void addPropertyName(String propertyName) {
            this.properties.add(propertyName);
        }

        void addRestoreProperty(String propertyName, String propertyValue) {
            this.restoreProperties.put(propertyName, propertyValue);
        }

        RestoreContext build() {
            return new RestoreContext(this.properties, this.restoreProperties);
        }
    }
}

