/*
 * Decompiled with CFR 0.152.
 */
package io.github.glytching.junit.extension.system;

import io.github.glytching.junit.extension.system.RestoreContext;
import io.github.glytching.junit.extension.system.SystemProperties;
import io.github.glytching.junit.extension.system.SystemProperty;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;

public class SystemPropertyExtension
implements AfterEachCallback,
BeforeEachCallback,
BeforeAllCallback,
AfterAllCallback {
    private static final String KEY = "restoreContext";

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        List<SystemProperty> systemProperties = this.getSystemProperties(extensionContext.getRequiredTestClass());
        if (!systemProperties.isEmpty()) {
            RestoreContext.Builder builder = RestoreContext.createBuilder();
            for (SystemProperty systemProperty : systemProperties) {
                builder.addPropertyName(systemProperty.name());
                if (System.getProperty(systemProperty.name()) != null) {
                    builder.addRestoreProperty(systemProperty.name(), System.getProperty(systemProperty.name()));
                }
                this.set(systemProperty);
            }
            this.writeRestoreContext(extensionContext, builder.build());
        }
    }

    public void afterAll(ExtensionContext extensionContext) throws Exception {
        RestoreContext restoreContext = this.readRestoreContext(extensionContext);
        if (restoreContext != null) {
            restoreContext.restore();
        }
    }

    public void beforeEach(ExtensionContext extensionContext) throws Exception {
        List<SystemProperty> systemProperties = this.getSystemProperties(extensionContext.getRequiredTestMethod());
        if (!systemProperties.isEmpty()) {
            RestoreContext.Builder builder = RestoreContext.createBuilder();
            for (SystemProperty systemProperty : systemProperties) {
                builder.addPropertyName(systemProperty.name());
                if (System.getProperty(systemProperty.name()) != null) {
                    builder.addRestoreProperty(systemProperty.name(), System.getProperty(systemProperty.name()));
                }
                this.set(systemProperty);
            }
            this.writeRestoreContext(extensionContext, builder.build());
        }
    }

    public void afterEach(ExtensionContext extensionContext) throws Exception {
        RestoreContext restoreContext = this.readRestoreContext(extensionContext);
        if (restoreContext != null) {
            restoreContext.restore();
        }
    }

    private List<SystemProperty> getSystemProperties(AnnotatedElement annotatedElement) {
        ArrayList<SystemProperty> systemProperties = new ArrayList<SystemProperty>();
        if (AnnotationUtils.isAnnotated((AnnotatedElement)annotatedElement, SystemProperties.class)) {
            systemProperties.addAll(Arrays.asList(annotatedElement.getAnnotation(SystemProperties.class).value()));
        }
        if (AnnotationUtils.isAnnotated((AnnotatedElement)annotatedElement, SystemProperty.class)) {
            systemProperties.add(annotatedElement.getAnnotation(SystemProperty.class));
        }
        return systemProperties;
    }

    private void set(SystemProperty systemProperty) {
        System.setProperty(systemProperty.name(), systemProperty.value());
    }

    private void writeRestoreContext(ExtensionContext extensionContext, RestoreContext restoreContext) {
        this.getStore(extensionContext).getOrComputeIfAbsent((Object)KEY, key -> restoreContext);
    }

    private RestoreContext readRestoreContext(ExtensionContext extensionContext) {
        return (RestoreContext)this.getStore(extensionContext).get((Object)KEY, RestoreContext.class);
    }

    private ExtensionContext.Store getStore(ExtensionContext extensionContext) {
        return extensionContext.getRoot().getStore(this.namespace(extensionContext));
    }

    private ExtensionContext.Namespace namespace(ExtensionContext extensionContext) {
        return ExtensionContext.Namespace.create((Object[])new Object[]{this.getClass(), extensionContext});
    }
}

