/*
 * Decompiled with CFR 0.152.
 */
package io.github.glytching.junit.extension.folder;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;

public class TemporaryFolder {
    private static final String FILE_PREFIX = "junit";
    private static final String FILE_SUFFIX = ".tmp";
    private final File rootFolder;

    TemporaryFolder() {
        try {
            this.rootFolder = File.createTempFile(FILE_PREFIX, FILE_SUFFIX);
            this.rootFolder.delete();
            this.rootFolder.mkdir();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public File getRoot() {
        return this.rootFolder;
    }

    public File createFile(String fileName) throws IOException {
        File result = new File(this.rootFolder, fileName);
        result.createNewFile();
        return result;
    }

    public File createDirectory(String directoryName) {
        File result = new File(this.rootFolder, directoryName);
        result.mkdirs();
        return result;
    }

    void destroy() throws IOException {
        if (this.rootFolder.exists()) {
            Files.walkFileTree(this.rootFolder.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) throws IOException {
                    return this.delete(file);
                }

                @Override
                public FileVisitResult postVisitDirectory(Path directory, IOException exception) throws IOException {
                    return this.delete(directory);
                }

                private FileVisitResult delete(Path file) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }
            });
            this.rootFolder.delete();
        }
    }
}

